/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii;

import com.itmuch.wii.WiiProperties;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class WiiHealthIndicator
extends AbstractHealthIndicator {
    private final WiiProperties wiiProperties;
    private final RestTemplate restTemplate;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            URI uri = this.wiiProperties.getHealthCheckUrl();
            if (uri == null) {
                builder.up();
                return;
            }
            ResponseEntity exchange = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){});
            Map map = (Map)exchange.getBody();
            if (map == null) {
                this.getWarning(builder);
                return;
            }
            Object status = map.get("status");
            if (status instanceof String) {
                builder.status(status.toString());
            } else {
                this.getWarning(builder);
            }
        }
        catch (Exception e) {
            builder.down().withDetail("error", (Object)e.getMessage());
        }
    }

    private void getWarning(Health.Builder builder) {
        builder.unknown().withDetail("warning", (Object)"no status field in response");
    }

    @Autowired
    public WiiHealthIndicator(WiiProperties wiiProperties, RestTemplate restTemplate) {
        this.wiiProperties = wiiProperties;
        this.restTemplate = restTemplate;
    }
}

