/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii.consul;

import com.ecwid.consul.v1.agent.model.NewService;
import com.itmuch.wii.WiiProperties;
import java.util.List;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulManagementRegistrationCustomizer;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class WiiConsulAutoRegistration
extends ConsulAutoRegistration {
    public WiiConsulAutoRegistration(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers) {
        super(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
    }

    public static ConsulAutoRegistration registration(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers, HeartbeatProperties heartbeatProperties, WiiProperties wiiProperties) {
        NewService service = new NewService();
        String appName = WiiConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)properties, (Environment)context.getEnvironment());
        service.setId(WiiConsulAutoRegistration.getInstanceId(wiiProperties, context.getEnvironment()));
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(wiiProperties.getIp());
        }
        service.setName(WiiConsulAutoRegistration.normalizeForDns((String)appName));
        service.setTags(WiiConsulAutoRegistration.createTags((ConsulDiscoveryProperties)properties));
        service.setPort(Integer.valueOf(context.getEnvironment().getProperty("server.port")));
        WiiConsulAutoRegistration.setCheck((NewService)service, (AutoServiceRegistrationProperties)autoServiceRegistrationProperties, (ConsulDiscoveryProperties)properties, (ApplicationContext)context, (HeartbeatProperties)heartbeatProperties);
        service.setPort(wiiProperties.getPort());
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
        WiiConsulAutoRegistration.customize(registrationCustomizers, (ConsulAutoRegistration)registration);
        return registration;
    }

    public static String getInstanceId(WiiProperties wiiProperties, Environment environment) {
        return String.format("%s-%s-%s", environment.getProperty("spring.application.name"), wiiProperties.getIp(), wiiProperties.getPort());
    }
}

