/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii.consul;

import com.itmuch.wii.WiiDiscoveryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;

public class WiiConsulDiscoveryClient
implements WiiDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(WiiConsulDiscoveryClient.class);
    private final ConsulDiscoveryProperties properties;
    private final ConsulServiceRegistry serviceRegistry;
    private final ConsulAutoRegistration registration;

    @Override
    public void registerInstance(String applicationName, String ip, Integer port) {
        if (!this.properties.isRegister()) {
            log.debug("Registration disabled.");
            return;
        }
        this.serviceRegistry.register((ConsulRegistration)this.registration);
    }

    @Override
    public void deregisterInstance(String applicationName, String ip, Integer port) {
        if (!this.properties.isRegister() || !this.properties.isDeregister()) {
            return;
        }
        this.serviceRegistry.deregister((ConsulRegistration)this.registration);
    }

    @Autowired
    public WiiConsulDiscoveryClient(ConsulDiscoveryProperties properties, ConsulServiceRegistry serviceRegistry, ConsulAutoRegistration registration) {
        this.properties = properties;
        this.serviceRegistry = serviceRegistry;
        this.registration = registration;
    }
}

