/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.itmuch.wii.WiiDiscoveryClient;
import com.itmuch.wii.nacos.WiiNacosDiscoveryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WiiNacosDiscoveryClient
implements WiiDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(WiiNacosDiscoveryClient.class);
    private final WiiNacosDiscoveryProperties wiiNacosDiscoveryProperties;

    @Override
    public void registerInstance(String applicationName, String ip, Integer port) {
        try {
            this.wiiNacosDiscoveryProperties.namingServiceInstance().registerInstance(applicationName, ip, port.intValue());
        }
        catch (NacosException e) {
            log.warn("nacos exception happens", (Throwable)e);
        }
    }

    @Override
    public void deregisterInstance(String applicationName, String ip, Integer port) {
        try {
            this.wiiNacosDiscoveryProperties.namingServiceInstance().deregisterInstance(applicationName, ip, port.intValue());
        }
        catch (NacosException e) {
            log.warn("nacos exception happens", (Throwable)e);
        }
    }

    @Autowired
    public WiiNacosDiscoveryClient(WiiNacosDiscoveryProperties wiiNacosDiscoveryProperties) {
        this.wiiNacosDiscoveryProperties = wiiNacosDiscoveryProperties;
    }
}

