/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.hotswap;

import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.hotswap.HotSwapResolver;
import java.net.URL;
import java.net.URLClassLoader;

public class HotSwapClassLoader
extends URLClassLoader {
    final ClassLoader parent;
    protected HotSwapResolver hotSwapResolver;

    public HotSwapClassLoader(URL[] urls, ClassLoader parent, HotSwapResolver hotSwapResolver) {
        super(urls, parent);
        this.parent = parent;
        this.hotSwapResolver = hotSwapResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!UndertowConfig.isDevMode()) {
            return super.loadClass(name, resolve);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (this.hotSwapResolver.isSystemClass(name)) {
                return this.parent.loadClass(name);
            }
            if (this.hotSwapResolver.isHotSwapClass(name) && (c = super.findClass(name)) != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return this.parent.loadClass(name);
        }
    }

    static {
        HotSwapClassLoader.registerAsParallelCapable();
    }
}

