/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

final class TokenEncoder<K, V> {
    private final Map<K, V> decodedToEncoded = new HashMap();
    private final Map<V, K> encodedToDecoded = new HashMap<V, K>();

    public TokenEncoder(Map<K, V> input) {
        this(input, Function.identity());
    }

    public <T> TokenEncoder(Map<T, V> input, Function<T, K> keyMapper) {
        for (Map.Entry<T, V> entry : input.entrySet()) {
            K key = keyMapper.apply(entry.getKey());
            V value = entry.getValue();
            this.decodedToEncoded.put(key, value);
            this.encodedToDecoded.put(value, key);
        }
    }

    public boolean containsDecodedToken(K decodedToken) {
        return this.decodedToEncoded.containsKey(decodedToken);
    }

    public V encode(K decodedToken) {
        V encoded = this.decodedToEncoded.get(decodedToken);
        if (encoded == null) {
            throw new IllegalArgumentException("Unknown token for encoding: " + decodedToken);
        }
        return encoded;
    }

    public Optional<V> encodeIfPresent(K decodedToken) {
        return Optional.ofNullable(this.decodedToEncoded.get(decodedToken));
    }

    public Optional<K> decodeIfPresent(V encodedToken) {
        return Optional.ofNullable(this.encodedToDecoded.get(encodedToken));
    }

    public Set<K> getDecodedTokens() {
        return Collections.unmodifiableSet(this.decodedToEncoded.keySet());
    }
}

