/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.codec;

import java.util.Arrays;

public class Base64 {
    private static final char[] encode = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] decode = new int[128];
    private static final char pad = '=';

    public static byte[] decode(char[] chars) {
        return Base64.decode(chars, decode, '=');
    }

    public static char[] encode(byte[] bytes) {
        return Base64.encode(bytes, encode, '=');
    }

    public static char[] encode(byte[] bytes, boolean padded) {
        return Base64.encode(bytes, encode, padded ? (char)'=' : '\u0000');
    }

    public static byte[] decode(char[] src, int[] table, char pad) {
        int n;
        int len = src.length;
        if (len == 0) {
            return new byte[0];
        }
        int padCount = src[len - 1] == pad ? (src[len - 2] == pad ? 2 : 1) : 0;
        int bytes = (len * 6 >> 3) - padCount;
        int blocks = bytes / 3 * 3;
        byte[] dst = new byte[bytes];
        int si = 0;
        int di = 0;
        while (di < blocks) {
            n = table[src[si++]] << 18 | table[src[si++]] << 12 | table[src[si++]] << 6 | table[src[si++]];
            dst[di++] = (byte)(n >> 16);
            dst[di++] = (byte)(n >> 8);
            dst[di++] = (byte)n;
        }
        if (di < bytes) {
            n = 0;
            switch (len - si) {
                case 4: {
                    n |= table[src[si + 3]];
                }
                case 3: {
                    n |= table[src[si + 2]] << 6;
                }
                case 2: {
                    n |= table[src[si + 1]] << 12;
                }
                case 1: {
                    n |= table[src[si]] << 18;
                }
            }
            int r = 16;
            while (di < bytes) {
                dst[di++] = (byte)(n >> r);
                r -= 8;
            }
        }
        return dst;
    }

    public static char[] encode(byte[] src, char[] table, char pad) {
        int n;
        int len = src.length;
        if (len == 0) {
            return new char[0];
        }
        int blocks = len / 3 * 3;
        int chars = (len - 1) / 3 + 1 << 2;
        int tail = len - blocks;
        if (pad == '\u0000' && tail > 0) {
            chars -= 3 - tail;
        }
        char[] dst = new char[chars];
        int si = 0;
        int di = 0;
        while (si < blocks) {
            n = (src[si++] & 0xFF) << 16 | (src[si++] & 0xFF) << 8 | src[si++] & 0xFF;
            dst[di++] = table[n >>> 18 & 0x3F];
            dst[di++] = table[n >>> 12 & 0x3F];
            dst[di++] = table[n >>> 6 & 0x3F];
            dst[di++] = table[n & 0x3F];
        }
        if (tail > 0) {
            n = (src[si] & 0xFF) << 10;
            if (tail == 2) {
                n |= (src[++si] & 0xFF) << 2;
            }
            dst[di++] = table[n >>> 12 & 0x3F];
            dst[di++] = table[n >>> 6 & 0x3F];
            if (tail == 2) {
                dst[di++] = table[n & 0x3F];
            }
            if (pad != '\u0000') {
                if (tail == 1) {
                    dst[di++] = pad;
                }
                dst[di] = pad;
            }
        }
        return dst;
    }

    static {
        Arrays.fill(decode, -1);
        for (int i = 0; i < encode.length; ++i) {
            Base64.decode[Base64.encode[i]] = i;
        }
        Base64.decode[61] = 0;
    }
}

