/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.cache.ICache;
import com.lark.oapi.core.cache.LocalCache;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.token.AppTicketManager;
import com.lark.oapi.core.token.GlobalAppTicketManager;
import com.lark.oapi.core.token.GlobalTokenManager;
import com.lark.oapi.core.token.TokenManager;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.service.acs.v1.AcsService;
import com.lark.oapi.service.admin.v1.AdminService;
import com.lark.oapi.service.application.v6.ApplicationService;
import com.lark.oapi.service.approval.v4.ApprovalService;
import com.lark.oapi.service.attendance.v1.AttendanceService;
import com.lark.oapi.service.baike.v1.BaikeService;
import com.lark.oapi.service.bitable.v1.BitableService;
import com.lark.oapi.service.block.v2.BlockService;
import com.lark.oapi.service.calendar.v4.CalendarService;
import com.lark.oapi.service.contact.v3.ContactService;
import com.lark.oapi.service.docx.v1.DocxService;
import com.lark.oapi.service.drive.v1.DriveService;
import com.lark.oapi.service.ehr.v1.EhrService;
import com.lark.oapi.service.event.v1.EventService;
import com.lark.oapi.service.ext.ExtService;
import com.lark.oapi.service.face_detection.v1.FaceDetectionService;
import com.lark.oapi.service.gray_test_open_sg.v1.GrayTestOpenSgService;
import com.lark.oapi.service.helpdesk.v1.HelpdeskService;
import com.lark.oapi.service.human_authentication.v1.HumanAuthenticationService;
import com.lark.oapi.service.im.v1.ImService;
import com.lark.oapi.service.mail.v1.MailService;
import com.lark.oapi.service.meeting_room.v1.MeetingRoomService;
import com.lark.oapi.service.optical_char_recognition.v1.OpticalCharRecognitionService;
import com.lark.oapi.service.passport.v1.PassportService;
import com.lark.oapi.service.search.v2.SearchService;
import com.lark.oapi.service.sheets.v3.SheetsService;
import com.lark.oapi.service.speech_to_text.v1.SpeechToTextService;
import com.lark.oapi.service.task.v1.TaskService;
import com.lark.oapi.service.tenant.v2.TenantService;
import com.lark.oapi.service.translation.v1.TranslationService;
import com.lark.oapi.service.vc.v1.VcService;
import com.lark.oapi.service.wiki.v2.WikiService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class Client {
    private Config config;
    private AcsService acs;
    private AdminService admin;
    private ApplicationService application;
    private ApprovalService approval;
    private AttendanceService attendance;
    private BaikeService baike;
    private BitableService bitable;
    private BlockService block;
    private CalendarService calendar;
    private ContactService contact;
    private DocxService docx;
    private DriveService drive;
    private EhrService ehr;
    private EventService event;
    private FaceDetectionService faceDetection;
    private GrayTestOpenSgService grayTestOpenSg;
    private HelpdeskService helpdesk;
    private HumanAuthenticationService humanAuthentication;
    private ImService im;
    private MailService mail;
    private MeetingRoomService meetingRoom;
    private OpticalCharRecognitionService opticalCharRecognition;
    private PassportService passport;
    private SearchService search;
    private SheetsService sheets;
    private SpeechToTextService speechToText;
    private TaskService task;
    private TenantService tenant;
    private TranslationService translation;
    private VcService vc;
    private WikiService wiki;
    private ExtService extService;

    public static Builder newBuilder(String appId, String appSecret) {
        return new Builder(appId, appSecret);
    }

    public ExtService ext() {
        return this.extService;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public AcsService acs() {
        return this.acs;
    }

    public AdminService admin() {
        return this.admin;
    }

    public ApplicationService application() {
        return this.application;
    }

    public ApprovalService approval() {
        return this.approval;
    }

    public AttendanceService attendance() {
        return this.attendance;
    }

    public BaikeService baike() {
        return this.baike;
    }

    public BitableService bitable() {
        return this.bitable;
    }

    public BlockService block() {
        return this.block;
    }

    public CalendarService calendar() {
        return this.calendar;
    }

    public ContactService contact() {
        return this.contact;
    }

    public DocxService docx() {
        return this.docx;
    }

    public DriveService drive() {
        return this.drive;
    }

    public EhrService ehr() {
        return this.ehr;
    }

    public EventService event() {
        return this.event;
    }

    public FaceDetectionService faceDetection() {
        return this.faceDetection;
    }

    public GrayTestOpenSgService grayTestOpenSg() {
        return this.grayTestOpenSg;
    }

    public HelpdeskService helpdesk() {
        return this.helpdesk;
    }

    public HumanAuthenticationService humanAuthentication() {
        return this.humanAuthentication;
    }

    public ImService im() {
        return this.im;
    }

    public MailService mail() {
        return this.mail;
    }

    public MeetingRoomService meetingRoom() {
        return this.meetingRoom;
    }

    public OpticalCharRecognitionService opticalCharRecognition() {
        return this.opticalCharRecognition;
    }

    public PassportService passport() {
        return this.passport;
    }

    public SearchService search() {
        return this.search;
    }

    public SheetsService sheets() {
        return this.sheets;
    }

    public SpeechToTextService speechToText() {
        return this.speechToText;
    }

    public TaskService task() {
        return this.task;
    }

    public TenantService tenant() {
        return this.tenant;
    }

    public TranslationService translation() {
        return this.translation;
    }

    public VcService vc() {
        return this.vc;
    }

    public WikiService wiki() {
        return this.wiki;
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public static final class Builder {
        private Config config = new Config();

        public Builder(String appId, String appSecret) {
            this.config.setAppId(appId);
            this.config.setAppSecret(appSecret);
            this.config.setBaseUrl(BaseUrlEnum.FeiShu.getUrl());
            this.config.setAppType(AppType.SELF_BUILT);
            this.config.setDisableTokenCache(false);
        }

        public Builder helpDeskCredential(String helpDeskId, String helpDeskToken) {
            this.config.setHelpDeskToken(helpDeskToken);
            this.config.setHelpDeskID(helpDeskId);
            if (Strings.isNotEmpty(helpDeskId) && Strings.isNotEmpty(helpDeskToken)) {
                this.config.setHelpDeskAuthToken(Base64.getEncoder().encodeToString(String.format("%s:%s", helpDeskId, helpDeskToken).getBytes(StandardCharsets.UTF_8)));
            }
            return this;
        }

        public Builder appType(AppType appType) {
            this.config.setAppType(appType);
            return this;
        }

        public Builder marketplaceApp() {
            this.config.setAppType(AppType.MARKETPLACE);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder logReqAtDebug(boolean logReqRespInfoAtDebugLevel) {
            this.config.setLogReqAtDebug(logReqRespInfoAtDebugLevel);
            return this;
        }

        public Builder openBaseUrl(String baseUrl) {
            this.config.setBaseUrl(baseUrl);
            return this;
        }

        public Builder openBaseUrl(BaseUrlEnum baseUrl) {
            this.config.setBaseUrl(baseUrl.getUrl());
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder requestTimeout(long timeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(timeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder httpTransport(IHttpTransport httpTransport) {
            this.config.setHttpTransport(httpTransport);
            return this;
        }

        private void initCache(Config config) {
            if (config.getCache() != null) {
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(config.getCache()));
                GlobalTokenManager.setTokenManager(new TokenManager(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(cache));
                GlobalTokenManager.setTokenManager(new TokenManager(cache));
            }
        }

        private void initHttpTransport(Config config) {
            if (config.getHttpTransport() == null) {
                if (config.getRequestTimeOut() > 0L) {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.create(config.getRequestTimeOut(), config.getTimeOutTimeUnit())));
                } else {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.defaultClient));
                }
            }
        }

        public Client build() {
            Client client = new Client();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            client.extService = new ExtService(this.config);
            client.acs = new AcsService(this.config);
            client.admin = new AdminService(this.config);
            client.application = new ApplicationService(this.config);
            client.approval = new ApprovalService(this.config);
            client.attendance = new AttendanceService(this.config);
            client.baike = new BaikeService(this.config);
            client.bitable = new BitableService(this.config);
            client.block = new BlockService(this.config);
            client.calendar = new CalendarService(this.config);
            client.contact = new ContactService(this.config);
            client.docx = new DocxService(this.config);
            client.drive = new DriveService(this.config);
            client.ehr = new EhrService(this.config);
            client.event = new EventService(this.config);
            client.faceDetection = new FaceDetectionService(this.config);
            client.grayTestOpenSg = new GrayTestOpenSgService(this.config);
            client.helpdesk = new HelpdeskService(this.config);
            client.humanAuthentication = new HumanAuthenticationService(this.config);
            client.im = new ImService(this.config);
            client.mail = new MailService(this.config);
            client.meetingRoom = new MeetingRoomService(this.config);
            client.opticalCharRecognition = new OpticalCharRecognitionService(this.config);
            client.passport = new PassportService(this.config);
            client.search = new SearchService(this.config);
            client.sheets = new SheetsService(this.config);
            client.speechToText = new SpeechToTextService(this.config);
            client.task = new TaskService(this.config);
            client.tenant = new TenantService(this.config);
            client.translation = new TranslationService(this.config);
            client.vc = new VcService(this.config);
            client.wiki = new WikiService(this.config);
            return client;
        }
    }
}

