/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.block.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.block.v2.model.CreateEntityReq;
import com.lark.oapi.service.block.v2.model.CreateEntityResp;
import com.lark.oapi.service.block.v2.model.CreateMessageReq;
import com.lark.oapi.service.block.v2.model.CreateMessageResp;
import com.lark.oapi.service.block.v2.model.UpdateEntityReq;
import com.lark.oapi.service.block.v2.model.UpdateEntityResp;

public class BlockService {
    private final Entity entity;
    private final Message message;

    public BlockService(Config config) {
        this.entity = new Entity(config);
        this.message = new Message(config);
    }

    public Entity entity() {
        return this.entity;
    }

    public Message message() {
        return this.message;
    }

    public static class Message {
        private final Config config;

        public Message(Config config) {
            this.config = config;
        }

        public CreateMessageResp create(CreateMessageReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            Boolean customSupportLong2Str = reqOptions.isSupportLong2String();
            reqOptions.setSupportLong2String(true);
            if (customSupportLong2Str != null) {
                reqOptions.setSupportLong2String(customSupportLong2Str);
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/block/v2/message", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateMessageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateMessageResp create(CreateMessageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportLong2String(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/block/v2/message", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateMessageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateMessageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Entity {
        private final Config config;

        public Entity(Config config) {
            this.config = config;
        }

        public CreateEntityResp create(CreateEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            Boolean customSupportLong2Str = reqOptions.isSupportLong2String();
            reqOptions.setSupportLong2String(true);
            if (customSupportLong2Str != null) {
                reqOptions.setSupportLong2String(customSupportLong2Str);
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/block/v2/entities", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateEntityResp create(CreateEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportLong2String(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/block/v2/entities", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateEntityResp update(UpdateEntityReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            Boolean customSupportLong2Str = reqOptions.isSupportLong2String();
            reqOptions.setSupportLong2String(true);
            if (customSupportLong2Str != null) {
                reqOptions.setSupportLong2String(customSupportLong2Str);
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/block/v2/entities/:block_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateEntityResp update(UpdateEntityReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportLong2String(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/block/v2/entities/:block_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            UpdateEntityResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateEntityResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

