/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.face_detection.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageReq;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageResp;

public class FaceDetectionService {
    private final Image image;

    public FaceDetectionService(Config config) {
        this.image = new Image(config);
    }

    public Image image() {
        return this.image;
    }

    public static class Image {
        private final Config config;

        public Image(Config config) {
            this.config = config;
        }

        public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            Boolean customSupportLong2Str = reqOptions.isSupportLong2String();
            reqOptions.setSupportLong2String(true);
            if (customSupportLong2Str != null) {
                reqOptions.setSupportLong2String(customSupportLong2Str);
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/face_detection/v1/image/detect_face_attributes", Sets.newHashSet(AccessTokenType.Tenant), req);
            DetectFaceAttributesImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectFaceAttributesImageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportLong2String(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/face_detection/v1/image/detect_face_attributes", Sets.newHashSet(AccessTokenType.Tenant), req);
            DetectFaceAttributesImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectFaceAttributesImageResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

