/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.tenant.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.tenant.v2.model.QueryTenantResp;

public class TenantService {
    private final Tenant tenant;

    public TenantService(Config config) {
        this.tenant = new Tenant(config);
    }

    public Tenant tenant() {
        return this.tenant;
    }

    public static class Tenant {
        private final Config config;

        public Tenant(Config config) {
            this.config = config;
        }

        public QueryTenantResp query(RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            Boolean customSupportLong2Str = reqOptions.isSupportLong2String();
            reqOptions.setSupportLong2String(true);
            if (customSupportLong2Str != null) {
                reqOptions.setSupportLong2String(customSupportLong2Str);
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/query", Sets.newHashSet(AccessTokenType.Tenant), null);
            QueryTenantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public QueryTenantResp query() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportLong2String(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/tenant/v2/tenant/query", Sets.newHashSet(AccessTokenType.Tenant), null);
            QueryTenantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }
}

