/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.translation.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.translation.v1.model.DetectTextReq;
import com.lark.oapi.service.translation.v1.model.DetectTextResp;
import com.lark.oapi.service.translation.v1.model.TranslateTextReq;
import com.lark.oapi.service.translation.v1.model.TranslateTextResp;

public class TranslationService {
    private final Text text;

    public TranslationService(Config config) {
        this.text = new Text(config);
    }

    public Text text() {
        return this.text;
    }

    public static class Text {
        private final Config config;

        public Text(Config config) {
            this.config = config;
        }

        public DetectTextResp detect(DetectTextReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/translation/v1/text/detect", Sets.newHashSet(AccessTokenType.Tenant), req);
            DetectTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectTextResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public DetectTextResp detect(DetectTextReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/translation/v1/text/detect", Sets.newHashSet(AccessTokenType.Tenant), req);
            DetectTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DetectTextResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public TranslateTextResp translate(TranslateTextReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/translation/v1/text/translate", Sets.newHashSet(AccessTokenType.Tenant), req);
            TranslateTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TranslateTextResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public TranslateTextResp translate(TranslateTextReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/translation/v1/text/translate", Sets.newHashSet(AccessTokenType.Tenant), req);
            TranslateTextResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TranslateTextResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }
}

