/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.mangofactory.swagger.scanners.RequestMappingPatternMatcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class RequestMappingEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingEvaluator.class);
    private List<Class<? extends Annotation>> excludeAnnotations;
    private RequestMappingPatternMatcher requestMappingPatternMatcher;
    private List<String> includePatterns;

    public RequestMappingEvaluator(List<Class<? extends Annotation>> excludeAnnotations, RequestMappingPatternMatcher requestMappingPatternMatcher, List<String> includePatterns) {
        this.excludeAnnotations = excludeAnnotations;
        this.requestMappingPatternMatcher = requestMappingPatternMatcher;
        this.includePatterns = includePatterns;
    }

    private boolean requestMappingMatchesAnIncludePattern(RequestMappingInfo requestMappingInfo) {
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        boolean isMatch = this.requestMappingPatternMatcher.patternConditionsMatchOneOfIncluded(patternsCondition, this.includePatterns);
        if (isMatch) {
            return true;
        }
        log.info(String.format("RequestMappingInfo did not match any include patterns: | %s", requestMappingInfo));
        return false;
    }

    public boolean shouldIncludeRequestMapping(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.requestMappingMatchesAnIncludePattern(requestMappingInfo) && !this.classHasIgnoredAnnotatedRequestMapping(handlerMethod.getMethod().getDeclaringClass()) && !this.hasIgnoredAnnotatedRequestMapping(handlerMethod);
    }

    public boolean shouldIncludePath(String path) {
        boolean isMatch = this.requestMappingPatternMatcher.pathMatchesOneOfIncluded(path, this.includePatterns);
        if (isMatch) {
            return true;
        }
        log.info(String.format("Path did not match any include patterns: | %s", path));
        return false;
    }

    public boolean classHasIgnoredAnnotatedRequestMapping(Class<?> handlerClass) {
        if (null != this.excludeAnnotations) {
            for (Class<? extends Annotation> annotation : this.excludeAnnotations) {
                if (!handlerClass.isAnnotationPresent(annotation)) continue;
                log.info(String.format("Excluding method as its class is annotated with: %s", annotation));
                return true;
            }
        }
        return false;
    }

    public boolean hasIgnoredAnnotatedRequestMapping(HandlerMethod handlerMethod) {
        if (null != this.excludeAnnotations) {
            for (Class<? extends Annotation> annotation : this.excludeAnnotations) {
                if (null == AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), annotation)) continue;
                log.info(String.format("Excluding method as it contains the excluded annotation: %s", annotation));
                return true;
            }
        }
        return false;
    }
}

