/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadSafeDateParse {
    private static final Logger logger = LoggerFactory.getLogger(ThreadSafeDateParse.class);
    private static final ThreadLocal<Map<String, DateFormat>> PARSERS = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };

    ThreadSafeDateParse() {
    }

    private static DateFormat getParser(String pattern) {
        Map<String, DateFormat> parserMap = PARSERS.get();
        DateFormat df = parserMap.get(pattern);
        if (df == null) {
            logger.debug("Date Format Pattern {} was not found in the current thread:{}", (Object)pattern, (Object)Thread.currentThread().getId());
            df = new SimpleDateFormat(pattern);
            parserMap.put(pattern, df);
        }
        return df;
    }

    public static Date parse(String srcDate, String pattern) throws ParseException {
        return ThreadSafeDateParse.getParser(pattern).parse(srcDate);
    }

    public static long parseLongDate(String srcDate, String pattern) throws ParseException {
        return ThreadSafeDateParse.parse(srcDate, pattern).getTime();
    }

    public static String format(Date theDate, String pattern) {
        return ThreadSafeDateParse.getParser(pattern).format(theDate);
    }

    public static String format(long theDate, String pattern) {
        return ThreadSafeDateParse.getParser(pattern).format(new Date(theDate));
    }
}

