/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.ArrayUtils;
import com.mzlion.core.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <T> List<T> asList(T ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }

    public static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        if (ArrayUtils.isEmpty(keys) || ArrayUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (int index = 0; index < size; ++index) {
            map.put(keys[index], values[index]);
        }
        return map;
    }

    public static Map<String, String> asMap(String keyStr, String valueStr, String delimiter) {
        if (StringUtils.isEmpty(keyStr) || StringUtils.isEmpty(valueStr)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isEmpty(delimiter)) {
            throw new IllegalArgumentException("The delimiter is invalid!");
        }
        String[] keys = keyStr.split(delimiter);
        String[] values = valueStr.split(delimiter);
        return CollectionUtils.asMap(keys, values);
    }

    public static Map<String, String> urlParam2Map(String urlParam) {
        if (StringUtils.isEmpty(urlParam)) {
            return Collections.emptyMap();
        }
        String[] arr = StringUtils.split(urlParam, "&");
        if (ArrayUtils.isEmpty(arr)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> params = new HashMap<String, String>(arr.length);
        for (String param : arr) {
            String[] kv;
            if (!StringUtils.hasText(param) || !StringUtils.hasLength((kv = StringUtils.split(param, "="))[0])) continue;
            params.put(kv[0], kv[1]);
        }
        return params;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return new String[0];
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String toString(Collection<String> collection) {
        return CollectionUtils.toString(collection, ",");
    }

    public static String toString(Collection<String> collection, String delimiter) {
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder builder = new StringBuilder();
        int size = collection.size();
        int i = 0;
        for (String str : collection) {
            if (i == size - 1) {
                builder.append(str);
            } else {
                builder.append(str).append(delimiter);
            }
            ++i;
        }
        return builder.toString();
    }

    public static String toString(Map<String, String> data) {
        return CollectionUtils.toString(data, "=", "&");
    }

    public static String toString(Map<String, String> data, String keyDelimiter, String entryDelimiter) {
        return CollectionUtils.toString(data, keyDelimiter, entryDelimiter, false, true);
    }

    private static String toString(Map<String, String> data, String keyDelimiter, String entryDelimiter, boolean keySortable, boolean ignoreEmpty) {
        if (CollectionUtils.isEmpty(data)) {
            return "";
        }
        if (keyDelimiter == null) {
            keyDelimiter = "";
        }
        if (entryDelimiter == null) {
            entryDelimiter = "";
        }
        int size = data.size();
        int i = 0;
        Set<String> keys = data.keySet();
        if (keySortable) {
            keys = new TreeSet<String>(keys);
        }
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            if (ignoreEmpty && StringUtils.hasLength(data.get(key))) {
                if (i == size - 1) {
                    builder.append(key).append(keyDelimiter).append(data.get(key));
                } else {
                    builder.append(key).append(keyDelimiter).append(data.get(key)).append(entryDelimiter);
                }
            } else if (!ignoreEmpty) {
                if (i == size - 1) {
                    builder.append(key).append(keyDelimiter).append(data.get(key));
                } else {
                    builder.append(key).append(keyDelimiter).append(data.get(key)).append(entryDelimiter);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public static String asCommonSignString(Map<String, String> params) {
        return CollectionUtils.toString(params, "=", "&", true, true);
    }
}

