/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.RuleMapWeightRandomLoadBalance;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.StrategyMapWeightRandomLoadBalance;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ZoneAvoidanceRuleDecorator
extends ZoneAvoidanceRule {
    private static final Logger LOG = LoggerFactory.getLogger(ZoneAvoidanceRuleDecorator.class);
    @Value(value="${spring.application.no.servers.retry.enabled:false}")
    private Boolean retryEnabled;
    @Value(value="${spring.application.no.servers.retry.times:5}")
    private Integer retryTimes;
    @Value(value="${spring.application.no.servers.retry.await.time:2000}")
    private Integer retryAwaitTime;
    @Autowired
    private StrategyMapWeightRandomLoadBalance strategyMapWeightRandomLoadBalance;
    @Autowired
    private RuleMapWeightRandomLoadBalance ruleMapWeightRandomLoadBalance;

    private List<Server> getServerList(Object key) {
        return this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
    }

    private List<Server> getRetryableServerList(Object key) {
        List<Server> serverList = this.getServerList(key);
        for (int i = 0; i < this.retryTimes && !CollectionUtils.isNotEmpty(serverList); ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.retryAwaitTime.intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.info("Retry to get server list for {} times...", (Object)(i + 1));
            serverList = this.getServerList(key);
        }
        return serverList;
    }

    public Server choose(Object key) {
        WeightFilterEntity ruleWeightFilterEntity;
        boolean isTriggered = false;
        WeightFilterEntity strategyWeightFilterEntity = this.strategyMapWeightRandomLoadBalance.getT();
        if (strategyWeightFilterEntity != null && strategyWeightFilterEntity.hasWeight()) {
            isTriggered = true;
            List<Server> serverList = this.retryEnabled != false ? this.getRetryableServerList(key) : this.getServerList(key);
            boolean isWeightChecked = this.strategyMapWeightRandomLoadBalance.checkWeight(serverList, strategyWeightFilterEntity);
            if (isWeightChecked) {
                try {
                    return this.strategyMapWeightRandomLoadBalance.choose(serverList, strategyWeightFilterEntity);
                }
                catch (Exception e) {
                    return super.choose(key);
                }
            }
            return super.choose(key);
        }
        if (!isTriggered && (ruleWeightFilterEntity = this.ruleMapWeightRandomLoadBalance.getT()) != null && ruleWeightFilterEntity.hasWeight()) {
            List<Server> serverList = this.retryEnabled != false ? this.getRetryableServerList(key) : this.getServerList(key);
            boolean isWeightChecked = this.ruleMapWeightRandomLoadBalance.checkWeight(serverList, ruleWeightFilterEntity);
            if (isWeightChecked) {
                try {
                    return this.ruleMapWeightRandomLoadBalance.choose(serverList, ruleWeightFilterEntity);
                }
                catch (Exception e) {
                    return super.choose(key);
                }
            }
            return super.choose(key);
        }
        return super.choose(key);
    }
}

