/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.event;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.AlarmEvent;
import com.nepxion.discovery.plugin.framework.event.ParameterChangedEvent;
import com.nepxion.discovery.plugin.framework.event.PluginPublisher;
import com.nepxion.discovery.plugin.framework.event.PluginSubscriber;
import com.nepxion.discovery.plugin.framework.event.RegisterFailureEvent;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleFailureEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionClearedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionUpdatedEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginEventWapper {
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginPublisher pluginPublisher;
    @Autowired
    private PluginSubscriber pluginSubscriber;

    public void fireRuleUpdated(RuleUpdatedEvent ruleUpdatedEvent, boolean async) {
        if (async) {
            this.pluginPublisher.asyncPublish(ruleUpdatedEvent);
        } else {
            this.pluginSubscriber.onRuleUpdated(ruleUpdatedEvent);
        }
    }

    public void fireRuleCleared(RuleClearedEvent ruleClearedEvent, boolean async) {
        if (async) {
            this.pluginPublisher.asyncPublish(ruleClearedEvent);
        } else {
            this.pluginSubscriber.onRuleCleared(ruleClearedEvent);
        }
    }

    public void fireRuleFailure(RuleFailureEvent ruleFailureEvent) {
        this.pluginPublisher.asyncPublish(ruleFailureEvent);
    }

    public void fireVersionUpdated(VersionUpdatedEvent versionUpdatedEvent, boolean async) {
        if (async) {
            this.pluginPublisher.asyncPublish(versionUpdatedEvent);
        } else {
            this.pluginSubscriber.onVersionUpdated(versionUpdatedEvent);
        }
    }

    public void fireVersionCleared(VersionClearedEvent versionClearedEvent, boolean async) {
        if (async) {
            this.pluginPublisher.asyncPublish(versionClearedEvent);
        } else {
            this.pluginSubscriber.onVersionCleared(versionClearedEvent);
        }
    }

    public void fireParameterChanged(ParameterChangedEvent parameterChangedEvent) {
        this.pluginPublisher.asyncPublish(parameterChangedEvent);
    }

    public void fireParameterChanged() {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        this.fireParameterChanged(new ParameterChangedEvent(ruleEntity != null ? ruleEntity.getParameterEntity() : null));
    }

    public void fireRegisterFailure(RegisterFailureEvent registerFailureEvent) {
        this.pluginPublisher.asyncPublish(registerFailureEvent);
    }

    public void fireAlarm(AlarmEvent alarmEvent) {
        this.pluginPublisher.asyncPublish(alarmEvent);
    }
}

