/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.loadbalance.weight;

import com.nepxion.discovery.common.entity.MapWeightEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.VersionWeightEntity;
import com.nepxion.discovery.common.entity.WeightEntityWrapper;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.AbstractWeightRandomLoadBalanceAdapter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StrategyWeightRandomLoadBalanceAdapter
extends AbstractWeightRandomLoadBalanceAdapter<WeightFilterEntity> {
    public StrategyWeightRandomLoadBalanceAdapter(PluginAdapter pluginAdapter, PluginContextHolder pluginContextHolder) {
        super(pluginAdapter, pluginContextHolder);
    }

    @Override
    public WeightFilterEntity getT() {
        String regionWeightValue;
        if (this.pluginContextHolder == null) {
            return null;
        }
        WeightFilterEntity weightFilterEntity = new WeightFilterEntity();
        String versionWeightValue = this.pluginContextHolder.getContextRouteVersionWeight();
        if (StringUtils.isNotEmpty((CharSequence)versionWeightValue)) {
            try {
                List weightEntityList = WeightEntityWrapper.parseWeightEntityList((String)versionWeightValue);
                weightFilterEntity.setVersionWeightEntityList(weightEntityList);
            }
            catch (Exception e) {
                VersionWeightEntity weightEntity = new VersionWeightEntity();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)weightEntity, (String)versionWeightValue);
                weightFilterEntity.setVersionWeightEntity(weightEntity);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionWeightValue = this.pluginContextHolder.getContextRouteRegionWeight()))) {
            try {
                List weightEntityList = WeightEntityWrapper.parseWeightEntityList((String)regionWeightValue);
                weightFilterEntity.setRegionWeightEntityList(weightEntityList);
            }
            catch (Exception e) {
                RegionWeightEntity weightEntity = new RegionWeightEntity();
                WeightEntityWrapper.parseWeightEntity((MapWeightEntity)weightEntity, (String)regionWeightValue);
                weightFilterEntity.setRegionWeightEntity(weightEntity);
            }
        }
        return weightFilterEntity;
    }

    @Override
    public int getWeight(Server server, WeightFilterEntity weightFilterEntity) {
        String providerServiceId = this.pluginAdapter.getServerServiceId(server);
        String providerVersion = this.pluginAdapter.getServerVersion(server);
        String providerRegion = this.pluginAdapter.getServerRegion(server);
        return WeightEntityWrapper.getWeight((WeightFilterEntity)weightFilterEntity, (String)providerServiceId, (String)providerVersion, (String)providerRegion, null);
    }
}

