/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.registercenter.eureka.context;

import com.nepxion.discovery.common.entity.DiscoveryType;
import com.nepxion.discovery.plugin.framework.adapter.ApplicationInfoAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginApplicationContextInitializer;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.util.MetadataUtil;
import com.nepxion.discovery.plugin.registercenter.eureka.decorator.EurekaServiceRegistryDecorator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringBootVersion;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EurekaApplicationContextInitializer
extends PluginApplicationContextInitializer {
    protected Object afterInitialization(ConfigurableApplicationContext applicationContext, Object bean, String beanName) throws BeansException {
        if (bean instanceof EurekaServiceRegistry) {
            EurekaServiceRegistry eurekaServiceRegistry = (EurekaServiceRegistry)bean;
            return new EurekaServiceRegistryDecorator(eurekaServiceRegistry, applicationContext);
        }
        if (bean instanceof EurekaInstanceConfigBean) {
            String gitVersion;
            String prefixGroup;
            ConfigurableEnvironment environment = applicationContext.getEnvironment();
            EurekaInstanceConfigBean eurekaInstanceConfig = (EurekaInstanceConfigBean)bean;
            eurekaInstanceConfig.setPreferIpAddress(true);
            Map metadata = eurekaInstanceConfig.getMetadataMap();
            String groupKey = PluginContextAware.getGroupKey((Environment)environment);
            if (!metadata.containsKey(groupKey)) {
                metadata.put(groupKey, "default");
            }
            if (!metadata.containsKey("version")) {
                metadata.put("version", "default");
            }
            if (!metadata.containsKey("region")) {
                metadata.put("region", "default");
            }
            if (StringUtils.isNotEmpty((CharSequence)(prefixGroup = this.getPrefixGroup(applicationContext)))) {
                metadata.put(groupKey, prefixGroup);
            }
            if (StringUtils.isNotEmpty((CharSequence)(gitVersion = this.getGitVersion(applicationContext)))) {
                metadata.put("version", gitVersion);
            }
            metadata.put("spring_boot_version", SpringBootVersion.getVersion());
            metadata.put("spring_application_name", PluginContextAware.getApplicationName((Environment)environment));
            metadata.put("spring_application_type", PluginContextAware.getApplicationType((Environment)environment));
            String applicationGatewayType = PluginContextAware.getApplicationGatewayType((Environment)environment);
            if (StringUtils.isNotEmpty((CharSequence)applicationGatewayType)) {
                metadata.put("spring_application_gateway_type", applicationGatewayType);
            }
            metadata.put("spring_application_protocol", PluginContextAware.getApplicationProtocol((Environment)environment));
            metadata.put("spring_application_uuid", PluginContextAware.getApplicationUUId((Environment)environment));
            metadata.put("spring_application_discovery_plugin", DiscoveryType.EUREKA.toString());
            metadata.put("spring_application_discovery_version", "6.12.1");
            String agentVersion = System.getProperty("spring.application.discovery.agent.version");
            metadata.put("spring_application_discovery_agent_version", StringUtils.isEmpty((CharSequence)agentVersion) ? "unknown" : agentVersion);
            metadata.put("spring_application_register_control_enabled", PluginContextAware.isRegisterControlEnabled((Environment)environment).toString());
            metadata.put("spring_application_discovery_control_enabled", PluginContextAware.isDiscoveryControlEnabled((Environment)environment).toString());
            metadata.put("spring_application_config_rest_control_enabled", PluginContextAware.isConfigRestControlEnabled((Environment)environment).toString());
            metadata.put("spring_application_group_key", groupKey);
            metadata.put("spring_application_context-path", PluginContextAware.getContextPath((Environment)environment));
            try {
                ApplicationInfoAdapter applicationInfoAdapter = (ApplicationInfoAdapter)applicationContext.getBean(ApplicationInfoAdapter.class);
                if (applicationInfoAdapter != null) {
                    metadata.put("app_id", applicationInfoAdapter.getAppId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MetadataUtil.filter((Map)metadata, (Environment)environment);
            return bean;
        }
        return bean;
    }
}

