/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.registercenter.eureka.decorator;

import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.listener.register.RegisterListenerExecutor;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EurekaServiceRegistryDecorator
extends EurekaServiceRegistry {
    private EurekaServiceRegistry serviceRegistry;
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;

    public EurekaServiceRegistryDecorator(EurekaServiceRegistry serviceRegistry, ConfigurableApplicationContext applicationContext) {
        this.serviceRegistry = serviceRegistry;
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    public void register(EurekaRegistration registration) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onRegister((Registration)registration);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.register(registration);
    }

    public void deregister(EurekaRegistration registration) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onDeregister((Registration)registration);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.deregister(registration);
    }

    public void setStatus(EurekaRegistration registration, String status) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onSetStatus((Registration)registration, status);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.setStatus(registration, status);
    }

    public Object getStatus(EurekaRegistration registration) {
        return this.serviceRegistry.getStatus(registration);
    }

    public void close() {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onClose();
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.close();
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }
}

