/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import java.util.Optional;
import java.util.concurrent.Semaphore;

public class SimpleLimiter<ContextT>
extends AbstractLimiter<ContextT> {
    private final MetricRegistry.SampleListener inflightDistribution;
    private final AdjustableSemaphore semaphore;

    public static Builder newBuilder() {
        return new Builder();
    }

    public SimpleLimiter(AbstractLimiter.Builder<?> builder) {
        super(builder);
        this.inflightDistribution = builder.registry.distribution("inflight", new String[0]);
        this.semaphore = new AdjustableSemaphore(this.getLimit());
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        Optional<Limiter.Listener> listener = this.shouldBypass(context) ? this.createBypassListener() : (!this.semaphore.tryAcquire() ? this.createRejectedListener() : Optional.of(new Listener(this.createListener())));
        this.inflightDistribution.addSample(this.getInflight());
        return listener;
    }

    @Override
    protected void onNewLimit(int newLimit) {
        int oldLimit = this.getLimit();
        super.onNewLimit(newLimit);
        if (newLimit > oldLimit) {
            this.semaphore.release(newLimit - oldLimit);
        } else {
            this.semaphore.reducePermits(oldLimit - newLimit);
        }
    }

    private class Listener
    implements Limiter.Listener {
        private final Limiter.Listener delegate;

        Listener(Limiter.Listener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onSuccess() {
            this.delegate.onSuccess();
            SimpleLimiter.this.semaphore.release();
        }

        @Override
        public void onIgnore() {
            this.delegate.onIgnore();
            SimpleLimiter.this.semaphore.release();
        }

        @Override
        public void onDropped() {
            this.delegate.onDropped();
            SimpleLimiter.this.semaphore.release();
        }
    }

    private static final class AdjustableSemaphore
    extends Semaphore {
        AdjustableSemaphore(int permits) {
            super(permits);
        }

        @Override
        public void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }

    public static class Builder
    extends AbstractLimiter.Builder<Builder> {
        public <ContextT> SimpleLimiter<ContextT> build() {
            return new SimpleLimiter(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

