/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.aop.aspectj;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixException;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutor;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import com.netflix.hystrix.contrib.javanica.exception.FallbackInvocationException;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import com.netflix.hystrix.contrib.javanica.utils.EnvUtils;
import com.netflix.hystrix.contrib.javanica.utils.FallbackMethod;
import com.netflix.hystrix.contrib.javanica.utils.MethodProvider;
import com.netflix.hystrix.contrib.javanica.utils.ajc.AjcUtils;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import rx.Observable;
import rx.functions.Func1;

@Aspect
public class HystrixCommandAspect {
    private static final Map<HystrixPointcutType, MetaHolderFactory> META_HOLDER_FACTORY_MAP = ImmutableMap.builder().put((Object)HystrixPointcutType.COMMAND, (Object)new CommandMetaHolderFactory()).put((Object)HystrixPointcutType.COLLAPSER, (Object)new CollapserMetaHolderFactory()).build();

    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand)")
    public void hystrixCommandAnnotationPointcut() {
    }

    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser)")
    public void hystrixCollapserAnnotationPointcut() {
    }

    @Around(value="hystrixCommandAnnotationPointcut() || hystrixCollapserAnnotationPointcut()")
    public Object methodsAnnotatedWithHystrixCommand(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        Validate.notNull((Object)method, (String)"failed to get method from joinPoint: %s", (Object[])new Object[]{joinPoint});
        if (method.isAnnotationPresent(HystrixCommand.class) && method.isAnnotationPresent(HystrixCollapser.class)) {
            throw new IllegalStateException("method cannot be annotated with HystrixCommand and HystrixCollapser annotations at the same time");
        }
        MetaHolderFactory metaHolderFactory = META_HOLDER_FACTORY_MAP.get((Object)HystrixPointcutType.of(method));
        MetaHolder metaHolder = metaHolderFactory.create(joinPoint);
        HystrixInvokable invokable = HystrixCommandFactory.getInstance().create(metaHolder);
        ExecutionType executionType = metaHolder.isCollapserAnnotationPresent() ? metaHolder.getCollapserExecutionType() : metaHolder.getExecutionType();
        try {
            result = !metaHolder.isObservable() ? CommandExecutor.execute(invokable, executionType, metaHolder) : this.executeObservable(invokable, executionType, metaHolder);
        }
        catch (HystrixBadRequestException e) {
            throw e.getCause();
        }
        catch (HystrixRuntimeException e) {
            throw this.hystrixRuntimeExceptionToThrowable(metaHolder, e);
        }
        return result;
    }

    private Observable executeObservable(HystrixInvokable invokable, ExecutionType executionType, final MetaHolder metaHolder) {
        return ((Observable)CommandExecutor.execute(invokable, executionType, metaHolder)).onErrorResumeNext((Func1)new Func1<Throwable, Observable>(){

            public Observable call(Throwable throwable) {
                if (throwable instanceof HystrixBadRequestException) {
                    return Observable.error((Throwable)throwable.getCause());
                }
                if (throwable instanceof HystrixRuntimeException) {
                    HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException)throwable;
                    return Observable.error((Throwable)HystrixCommandAspect.this.hystrixRuntimeExceptionToThrowable(metaHolder, hystrixRuntimeException));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    private Throwable hystrixRuntimeExceptionToThrowable(MetaHolder metaHolder, HystrixRuntimeException e) {
        if (metaHolder.raiseHystrixExceptionsContains(HystrixException.RUNTIME_EXCEPTION)) {
            return e;
        }
        return this.getCause(e);
    }

    private Throwable getCause(HystrixRuntimeException e) {
        if (e.getFailureType() != HystrixRuntimeException.FailureType.COMMAND_EXCEPTION) {
            return e;
        }
        Throwable cause = e.getCause();
        if (e.getFallbackException() instanceof FallbackInvocationException) {
            cause = e.getFallbackException().getCause();
            if (cause instanceof HystrixRuntimeException) {
                cause = this.getCause((HystrixRuntimeException)cause);
            }
        } else if (cause instanceof CommandActionExecutionException) {
            CommandActionExecutionException commandActionExecutionException = (CommandActionExecutionException)cause;
            cause = commandActionExecutionException.getCause();
        }
        return (Throwable)Optional.fromNullable((Object)cause).or((Object)e);
    }

    private static Method getAjcMethodFromTarget(JoinPoint joinPoint) {
        return AjcUtils.getAjcMethodAroundAdvice(joinPoint.getTarget().getClass(), (MethodSignature)joinPoint.getSignature());
    }

    private static Class<?> getFirstGenericParameter(Type type) {
        return HystrixCommandAspect.getFirstGenericParameter(type, 1);
    }

    private static Class<?> getFirstGenericParameter(Type type, int nestedDepth) {
        int cDepth = 0;
        Type tType = type;
        for (int cDept = 0; cDept < nestedDepth; ++cDept) {
            if (!(tType instanceof ParameterizedType)) {
                throw new IllegalStateException(String.format("Sub type at nesting level %d of %s is expected to be generic", cDepth, type));
            }
            tType = ((ParameterizedType)tType).getActualTypeArguments()[cDept];
        }
        if (tType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)tType).getRawType();
        }
        if (tType instanceof Class) {
            return (Class)tType;
        }
        throw new UnsupportedOperationException("Unsupported type " + tType);
    }

    private static MetaHolder.Builder setDefaultProperties(MetaHolder.Builder builder, Class<?> declaringClass, ProceedingJoinPoint joinPoint) {
        Optional<DefaultProperties> defaultPropertiesOpt = AopUtils.getAnnotation((JoinPoint)joinPoint, DefaultProperties.class);
        builder.defaultGroupKey(declaringClass.getSimpleName());
        if (defaultPropertiesOpt.isPresent()) {
            DefaultProperties defaultProperties = (DefaultProperties)defaultPropertiesOpt.get();
            builder.defaultProperties(defaultProperties);
            if (StringUtils.isNotBlank((CharSequence)defaultProperties.groupKey())) {
                builder.defaultGroupKey(defaultProperties.groupKey());
            }
            if (StringUtils.isNotBlank((CharSequence)defaultProperties.threadPoolKey())) {
                builder.defaultThreadPoolKey(defaultProperties.threadPoolKey());
            }
        }
        return builder;
    }

    private static MetaHolder.Builder setFallbackMethod(MetaHolder.Builder builder, Class<?> declaringClass, Method commandMethod) {
        FallbackMethod fallbackMethod = MethodProvider.getInstance().getFallbackMethod(declaringClass, commandMethod);
        if (fallbackMethod.isPresent()) {
            fallbackMethod.validateReturnType(commandMethod);
            builder.fallbackMethod(fallbackMethod.getMethod()).fallbackExecutionType(ExecutionType.getExecutionType(fallbackMethod.getMethod().getReturnType()));
        }
        return builder;
    }

    private static enum HystrixPointcutType {
        COMMAND,
        COLLAPSER;


        static HystrixPointcutType of(Method method) {
            return method.isAnnotationPresent(HystrixCommand.class) ? COMMAND : COLLAPSER;
        }
    }

    private static class CommandMetaHolderFactory
    extends MetaHolderFactory {
        private CommandMetaHolderFactory() {
        }

        @Override
        public MetaHolder create(Object proxy, Method method, Object obj, Object[] args, ProceedingJoinPoint joinPoint) {
            HystrixCommand hystrixCommand = method.getAnnotation(HystrixCommand.class);
            ExecutionType executionType = ExecutionType.getExecutionType(method.getReturnType());
            MetaHolder.Builder builder = this.metaHolderBuilder(proxy, method, obj, args, joinPoint);
            if (EnvUtils.isCompileWeaving()) {
                builder.ajcMethod(HystrixCommandAspect.getAjcMethodFromTarget((JoinPoint)joinPoint));
            }
            return builder.defaultCommandKey(method.getName()).hystrixCommand(hystrixCommand).observableExecutionMode(hystrixCommand.observableExecutionMode()).executionType(executionType).observable(ExecutionType.OBSERVABLE == executionType).build();
        }
    }

    private static class CollapserMetaHolderFactory
    extends MetaHolderFactory {
        private CollapserMetaHolderFactory() {
        }

        @Override
        public MetaHolder create(Object proxy, Method collapserMethod, Object obj, Object[] args, ProceedingJoinPoint joinPoint) {
            Class batchCommandActualReturnType;
            HystrixCollapser hystrixCollapser = collapserMethod.getAnnotation(HystrixCollapser.class);
            if (collapserMethod.getParameterTypes().length > 1 || collapserMethod.getParameterTypes().length == 0) {
                throw new IllegalStateException("Collapser method must have one argument: " + collapserMethod);
            }
            Method batchCommandMethod = AopUtils.getDeclaredMethod(obj.getClass(), hystrixCollapser.batchMethod(), List.class);
            if (batchCommandMethod == null) {
                throw new IllegalStateException("batch method is absent: " + hystrixCollapser.batchMethod());
            }
            Class<?> batchReturnType = batchCommandMethod.getReturnType();
            Class<?> collapserReturnType = collapserMethod.getReturnType();
            boolean observable = collapserReturnType.equals(Observable.class);
            if (!collapserMethod.getParameterTypes()[0].equals(HystrixCommandAspect.getFirstGenericParameter(batchCommandMethod.getGenericParameterTypes()[0]))) {
                throw new IllegalStateException("required batch method for collapser is absent, wrong generic type: expected " + obj.getClass().getCanonicalName() + "." + hystrixCollapser.batchMethod() + "(java.util.List<" + collapserMethod.getParameterTypes()[0] + ">), but it's " + HystrixCommandAspect.getFirstGenericParameter(batchCommandMethod.getGenericParameterTypes()[0]));
            }
            Class collapserMethodReturnType = HystrixCommandAspect.getFirstGenericParameter(collapserMethod.getGenericReturnType(), Future.class.isAssignableFrom(collapserReturnType) || Observable.class.isAssignableFrom(collapserReturnType) ? 1 : 0);
            if (!collapserMethodReturnType.equals(batchCommandActualReturnType = HystrixCommandAspect.getFirstGenericParameter(batchCommandMethod.getGenericReturnType()))) {
                throw new IllegalStateException("Return type of batch method must be java.util.List parametrized with corresponding type: expected (java.util.List<" + collapserMethodReturnType + ">)" + obj.getClass().getCanonicalName() + "." + hystrixCollapser.batchMethod() + "(java.util.List<" + collapserMethod.getParameterTypes()[0] + ">), but it's " + batchCommandActualReturnType);
            }
            HystrixCommand hystrixCommand = batchCommandMethod.getAnnotation(HystrixCommand.class);
            if (hystrixCommand == null) {
                throw new IllegalStateException("batch method must be annotated with HystrixCommand annotation");
            }
            MetaHolder.Builder builder = this.metaHolderBuilder(proxy, batchCommandMethod, obj, args, joinPoint);
            if (EnvUtils.isCompileWeaving()) {
                builder.ajcMethod(AjcUtils.getAjcMethodAroundAdvice(obj.getClass(), batchCommandMethod.getName(), List.class));
            }
            builder.hystrixCollapser(hystrixCollapser);
            builder.defaultCollapserKey(collapserMethod.getName());
            builder.collapserExecutionType(ExecutionType.getExecutionType(collapserReturnType));
            builder.defaultCommandKey(batchCommandMethod.getName());
            builder.hystrixCommand(hystrixCommand);
            builder.executionType(ExecutionType.getExecutionType(batchReturnType));
            builder.observable(observable);
            FallbackMethod fallbackMethod = MethodProvider.getInstance().getFallbackMethod(obj.getClass(), batchCommandMethod);
            if (fallbackMethod.isPresent()) {
                fallbackMethod.validateReturnType(batchCommandMethod);
                builder.fallbackMethod(fallbackMethod.getMethod()).fallbackExecutionType(ExecutionType.getExecutionType(fallbackMethod.getMethod().getReturnType()));
            }
            return builder.build();
        }
    }

    private static abstract class MetaHolderFactory {
        private MetaHolderFactory() {
        }

        public MetaHolder create(ProceedingJoinPoint joinPoint) {
            Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
            Object obj = joinPoint.getTarget();
            Object[] args = joinPoint.getArgs();
            Object proxy = joinPoint.getThis();
            return this.create(proxy, method, obj, args, joinPoint);
        }

        public abstract MetaHolder create(Object var1, Method var2, Object var3, Object[] var4, ProceedingJoinPoint var5);

        MetaHolder.Builder metaHolderBuilder(Object proxy, Method method, Object obj, Object[] args, ProceedingJoinPoint joinPoint) {
            MetaHolder.Builder builder = MetaHolder.builder().args(args).method(method).obj(obj).proxyObj(proxy).joinPoint((JoinPoint)joinPoint);
            HystrixCommandAspect.setFallbackMethod(builder, obj.getClass(), method);
            builder = HystrixCommandAspect.setDefaultProperties(builder, obj.getClass(), joinPoint);
            return builder;
        }
    }
}

