/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.oauth2.sdk.AssertionGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class SAML2BearerGrant
extends AssertionGrant {
    public static final GrantType GRANT_TYPE = GrantType.SAML2_BEARER;
    private static final ParseException UNSUPPORTED_GRANT_TYPE_EXCEPTION = new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
    private final Base64URL assertion;

    public SAML2BearerGrant(Base64URL assertion) {
        super(GRANT_TYPE);
        if (assertion == null) {
            throw new IllegalArgumentException("The SAML 2.0 bearer assertion must not be null");
        }
        this.assertion = assertion;
    }

    public Base64URL getSAML2Assertion() {
        return this.assertion;
    }

    @Override
    public String getAssertion() {
        return this.assertion.toString();
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("assertion", this.assertion.toString());
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAML2BearerGrant that = (SAML2BearerGrant)o;
        return this.assertion.equals((Object)that.assertion);
    }

    public int hashCode() {
        return this.assertion.hashCode();
    }

    public static SAML2BearerGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw MISSING_GRANT_TYPE_PARAM_EXCEPTION;
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            throw UNSUPPORTED_GRANT_TYPE_EXCEPTION;
        }
        String assertionString = params.get("assertion");
        if (assertionString == null || assertionString.trim().isEmpty()) {
            throw MISSING_ASSERTION_PARAM_EXCEPTION;
        }
        return new SAML2BearerGrant(new Base64URL(assertionString));
    }
}

