/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.util.logging.UCPLoggerFactory;

class OracleDatabaseInstanceInfo {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleDatabaseInstanceInfo.class.getCanonicalName());
    static final int STATUS_UP = 1;
    static final int STATUS_DOWN = 2;
    private final String databaseUniqueName;
    private final String instanceName;
    private final String hostName;
    String serviceName = null;
    int percent = 0;
    int flag = 2;
    int attemptedConnRequestCount = 0;
    int numberOfConnectionsCount = 0;
    int status = 1;
    int numToTearDown = -1;
    String namedInstanceUrl = null;
    int numNamedInstanceConns = 0;
    int id = -1;
    String m_equalKey;
    final String m_hashKey;
    private final int m_hashCode;
    private int[] percentHistory = new int[4];
    private int frameNumber = -1;

    OracleDatabaseInstanceInfo(String databaseUniqueName, String instanceName) {
        this(databaseUniqueName, instanceName, null);
    }

    OracleDatabaseInstanceInfo(String databaseUniqueName, String instanceName, String hostName) {
        logger.log(Level.FINEST, "DatabaseUniqName: {0}, InstanceName: {1}, HostName: {2}", new Object[]{databaseUniqueName, instanceName, hostName});
        this.databaseUniqueName = databaseUniqueName;
        this.instanceName = instanceName;
        this.hostName = hostName;
        StringBuffer sbuf = new StringBuffer(128);
        sbuf.append(instanceName == null ? "" : instanceName).append("##").append(databaseUniqueName == null ? "" : databaseUniqueName);
        this.m_hashKey = sbuf.toString();
        this.m_hashCode = this.m_hashKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OracleDatabaseInstanceInfo)) {
            return false;
        }
        OracleDatabaseInstanceInfo other = (OracleDatabaseInstanceInfo)obj;
        String key = this.m_hashKey == null ? "" : this.m_hashKey;
        String okey = other.m_hashKey == null ? "" : other.m_hashKey;
        return key.equals(okey);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return "Database unique name: " + this.databaseUniqueName + ", Instance name: " + this.instanceName + ", Service name: " + this.serviceName + ", Host name: " + this.hostName + ", Instance id: " + this.id + ", percent: " + this.percent + ", Flag: " + this.flag + ", Attempted connection request count: " + this.attemptedConnRequestCount + ", Connection count: " + this.numberOfConnectionsCount + ", Status: " + (this.status == 1 ? "UP" : "DOWN");
    }

    String getDatabaseName() {
        return this.databaseUniqueName;
    }

    String getInstanceName() {
        return this.instanceName;
    }

    String getHostName() {
        return this.hostName;
    }

    synchronized int getAttemptedConnRequestCount() {
        return this.attemptedConnRequestCount;
    }

    synchronized void incrementAttemptedConnRequestCount() {
        ++this.attemptedConnRequestCount;
    }

    synchronized void decrementAttemptedConnRequestCount() {
        if (this.attemptedConnRequestCount > 0) {
            --this.attemptedConnRequestCount;
        }
    }

    synchronized void setAttemptedConnRequestCount(int count) {
        this.attemptedConnRequestCount = count;
    }

    synchronized int getNumberOfConnectionsCount() {
        return this.numberOfConnectionsCount;
    }

    synchronized void incrementNumberOfConnectionsCount() {
        ++this.numberOfConnectionsCount;
    }

    synchronized void decrementNumberOfConnectionsCount() {
        assert (this.numberOfConnectionsCount >= 0) : "internal error: numberOfCOnnectionsCount cannot be negative";
        --this.numberOfConnectionsCount;
    }

    synchronized void setNumberOfConnectionsCount(int count) {
        this.numberOfConnectionsCount = count;
    }

    synchronized void updatePercentHistory(int p) {
        this.percentHistory[++this.frameNumber % this.percentHistory.length] = p;
    }

    synchronized float getSmoothedPercent() {
        if (this.frameNumber < 1) {
            return this.percent;
        }
        int items = Math.min(this.frameNumber + 1, this.percentHistory.length);
        float sum = 0.0f;
        StringBuilder sb = new StringBuilder();
        sb.append("+++ history%: ");
        for (int i = 0; i < items; ++i) {
            sum += (float)this.percentHistory[i];
            sb.append(this.percentHistory[i]).append(", ");
        }
        float smoothedPercent = sum / (float)items;
        sb.append("smoothed%: ").append(smoothedPercent);
        logger.finest(sb.toString());
        return smoothedPercent;
    }
}

