/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.PreparedStatementProxyFactory;
import oracle.ucp.jdbc.proxy.StatementProxyFactory;

@DisableTrace
public class CallableStatementProxyFactory
extends PreparedStatementProxyFactory
implements InvocationHandler,
LogicalObject {
    protected static ConcurrentMap<Class, Constructor> constructorMap = new ConcurrentHashMap<Class, Constructor>();

    public static Object createCallableStatementProxy(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedStatement == null) {
            return null;
        }
        Object stmtProxy = null;
        try {
            stmtProxy = CallableStatementProxyFactory.createProxyHelper(proxyConnection.getClass().getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
        }
        catch (Throwable e) {
            try {
                stmtProxy = CallableStatementProxyFactory.createProxyHelper(StatementProxyFactory.class.getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
            }
            catch (Throwable ee) {
                throw new UniversalConnectionPoolException(ee);
            }
        }
        return stmtProxy;
    }

    private static Object createProxyHelper(ClassLoader clsLoader, Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws Exception {
        Class<?> stmtClass = proxiedStatement.getClass();
        Constructor<?> constructor = (Constructor<?>)constructorMap.get(stmtClass);
        if (constructor == null) {
            Class<?> pxyClass = Proxy.getProxyClass(clsLoader, CallableStatementProxyFactory.createInterfaces(proxiedStatement));
            constructor = pxyClass.getConstructor(InvocationHandler.class);
        }
        Object stmtProxy = constructor.newInstance(new StatementProxyFactory(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection));
        if (null == constructorMap.putIfAbsent(stmtClass, constructor)) {
        }
        return stmtProxy;
    }

    protected CallableStatementProxyFactory(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return super.invoke(proxy, method, args);
    }
}

