/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.parser;

import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.io.ResourceStreamSource;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntityImpl;
import com.pangu.form.engine.impl.persistence.entity.FormDeploymentEntity;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import com.pangubpm.editor.form.FormJsonConverter;
import com.pangubpm.form.model.original.FormOriginalModel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDefinitionParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormDefinitionParse.class);
    protected String name;
    protected boolean validateSchema = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected FormOriginalModel formModel;
    protected String targetNamespace;
    protected FormDeploymentEntity deployment;
    protected List<FormDefinitionEntity> formDefinitions = new ArrayList<FormDefinitionEntity>();

    public FormDefinitionParse deployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public FormDefinitionParse execute(FormEngineConfiguration formEngineConfig) {
        String encoding = formEngineConfig.getXmlEncoding();
        FormJsonConverter converter = new FormJsonConverter();
        try {
            InputStreamReader in = null;
            in = encoding != null ? new InputStreamReader(this.streamSource.getInputStream(), encoding) : new InputStreamReader(this.streamSource.getInputStream());
            String formJson = IOUtils.toString((Reader)in);
            this.formModel = converter.convertToFormModel(formJson, false);
            FormDefinitionEntity formDefinitionEntity = (FormDefinitionEntity)CommandContextUtil.getFormEngineConfiguration().getFormDefinitionEntityManager().create();
            formDefinitionEntity.setResourceName(this.name);
            formDefinitionEntity.setDeploymentId(this.deployment.getId());
            this.formDefinitions.add(formDefinitionEntity);
            Object formDefinitionEntityThread = ThreadMapUtil.get((String)"formDefinitionEntity");
            if (formDefinitionEntityThread != null && !(formDefinitionEntityThread instanceof String)) {
                FormDefinitionEntityImpl formDefinitionEntityThreadCast = (FormDefinitionEntityImpl)formDefinitionEntityThread;
                formDefinitionEntity.setResourceName(formDefinitionEntityThreadCast.getResourceName());
                formDefinitionEntity.setKey(formDefinitionEntityThreadCast.getKey());
                formDefinitionEntity.setName(formDefinitionEntityThreadCast.getName());
                formDefinitionEntity.setCategory(formDefinitionEntityThreadCast.getCategory());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form definition JSON", (Throwable)e);
        }
        return this;
    }

    public FormDefinitionParse name(String name) {
        this.name = name;
        return this;
    }

    public FormDefinitionParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public FormDefinitionParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public FormDefinitionParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("malformed url: " + url, (Throwable)e);
        }
    }

    public FormDefinitionParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public FormDefinitionParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new FlowableException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public FormDefinitionParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public List<FormDefinitionEntity> getFormDefinitions() {
        return this.formDefinitions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public FormDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public StreamSource getStreamSource() {
        return this.streamSource;
    }

    public FormOriginalModel getFormModel() {
        return this.formModel;
    }

    public void setFormModel(FormOriginalModel formModel) {
        this.formModel = formModel;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setFormDefinitions(List<FormDefinitionEntity> formDefinitions) {
        this.formDefinitions = formDefinitions;
    }
}

