/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pangu.form.api.FormInfo;
import com.pangu.form.api.FormInstance;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntity;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntity;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractSaveFormInstanceCmd
implements Command<FormInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    ObjectMapper objectMapper = new ObjectMapper();
    protected String formModelId;
    protected FormInfo formInfo;
    protected Map<String, Object> variables;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String scopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String tenantId;
    protected String outcome;

    public AbstractSaveFormInstanceCmd(FormInfo formInfo, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        this.formInfo = formInfo;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(FormInfo formInfo, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        this.formInfo = formInfo;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public FormInstance execute(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        if (this.formInfo == null) {
            if (this.formModelId == null) {
                throw new FlowableException("Invalid form model and no form model Id provided");
            }
            this.formInfo = CommandContextUtil.getFormEngineConfiguration().getFormRepositoryService().getFormModelById(this.formModelId);
        }
        if (this.formInfo == null || this.formInfo.getId() == null) {
            throw new FlowableException("Invalid form model provided");
        }
        FormDefinitionEntity formDefinitionEntity = (FormDefinitionEntity)CommandContextUtil.getFormDefinitionEntityManager(commandContext).findById(this.formInfo.getId());
        String deploymentId = formDefinitionEntity.getDeploymentId();
        List<FormResourceEntity> resourcesByDeploymentId = CommandContextUtil.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
        FormResourceEntity formResourceEntity = resourcesByDeploymentId.get(0);
        byte[] bytes = formResourceEntity.getBytes();
        try {
            String str = new String(bytes, "UTF-8");
            String formDataObj = "";
            if (this.variables.get("formData") != null) {
                formDataObj = (String)this.variables.get("formData");
            }
            FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
            FormInstanceEntity formInstanceEntity = this.findExistingFormInstance(formEngineConfiguration);
            if (formInstanceEntity == null) {
                formInstanceEntity = (FormInstanceEntity)formInstanceEntityManager.create();
            }
            formInstanceEntity.setFormDefinitionId(this.formInfo.getId());
            formInstanceEntity.setTaskId(this.taskId);
            if (this.processInstanceId != null) {
                formInstanceEntity.setProcessInstanceId(this.processInstanceId);
                formInstanceEntity.setProcessDefinitionId(this.processDefinitionId);
            } else {
                formInstanceEntity.setScopeId(this.scopeId);
                formInstanceEntity.setScopeType(this.scopeType);
                formInstanceEntity.setScopeDefinitionId(this.scopeDefinitionId);
            }
            formInstanceEntity.setSubmittedDate(formEngineConfiguration.getClock().getCurrentTime());
            formInstanceEntity.setSubmittedBy(Authentication.getAuthenticatedUserId());
            if (this.tenantId != null) {
                formInstanceEntity.setTenantId(this.tenantId);
            }
            try {
                formInstanceEntity.setFormValueBytes(formDataObj.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new FlowableException("Error setting form values JSON", (Throwable)e);
            }
            if (formInstanceEntity.getId() == null) {
                formInstanceEntityManager.insert(formInstanceEntity);
            } else {
                formInstanceEntityManager.update(formInstanceEntity);
            }
            return formInstanceEntity;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract FormInstanceEntity findExistingFormInstance(FormEngineConfiguration var1);
}

