/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.pangu.form.api.FormInstance;
import com.pangu.form.engine.impl.FormInstanceQueryImpl;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntityManager;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteFormInstancesByFormDefinitionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;

    public DeleteFormInstancesByFormDefinitionCmd(String formDefinitionId) {
        this.formDefinitionId = formDefinitionId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.formDefinitionId == null) {
            throw new FlowableIllegalArgumentException("formDefinitionId is null");
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormResourceEntityManager resourceEntityManager = CommandContextUtil.getResourceEntityManager(commandContext);
        FormInstanceQueryImpl formInstanceQuery = new FormInstanceQueryImpl(commandContext);
        formInstanceQuery.formDefinitionId(this.formDefinitionId);
        List<FormInstance> formInstances = formInstanceEntityManager.findFormInstancesByQueryCriteria(formInstanceQuery);
        for (FormInstance formInstance : formInstances) {
            if (formInstance.getFormValuesId() == null) continue;
            resourceEntityManager.delete(formInstance.getFormValuesId());
        }
        formInstanceEntityManager.deleteFormInstancesByFormDefinitionId(this.formDefinitionId);
        return null;
    }
}

