/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.oss.service;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.pig4cloud.plugin.oss.OssProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;

public class OssTemplate
implements InitializingBean {
    private final OssProperties ossProperties;
    private AmazonS3 amazonS3;

    public void createBucket(String bucketName) {
        if (!this.amazonS3.doesBucketExistV2(bucketName)) {
            this.amazonS3.createBucket(bucketName);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.amazonS3.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.amazonS3.listBuckets().stream().filter(b -> b.getName().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.amazonS3.deleteBucket(bucketName);
    }

    public List<S3ObjectSummary> getAllObjectsByPrefix(String bucketName, String prefix) {
        ObjectListing objectListing = this.amazonS3.listObjects(bucketName, prefix);
        return new ArrayList<S3ObjectSummary>(objectListing.getObjectSummaries());
    }

    public String getObjectURL(String bucketName, String objectName, int minutes) {
        return this.getObjectURL(bucketName, objectName, Duration.ofMinutes(minutes));
    }

    public String getObjectURL(String bucketName, String objectName, Duration expires) {
        return this.getObjectURL(bucketName, objectName, expires, HttpMethod.GET);
    }

    public String getPutObjectURL(String bucketName, String objectName, int minutes) {
        return this.getObjectURL(bucketName, objectName, Duration.ofMinutes(minutes));
    }

    public String getPutObjectURL(String bucketName, String objectName, Duration expires) {
        return this.getObjectURL(bucketName, objectName, expires, HttpMethod.PUT);
    }

    public String getObjectURL(String bucketName, String objectName, int minutes, HttpMethod method) {
        return this.getObjectURL(bucketName, objectName, Duration.ofMinutes(minutes), method);
    }

    public String getObjectURL(String bucketName, String objectName, Duration expires, HttpMethod method) {
        Date expiration = Date.from(Instant.now().plus(expires));
        URL url = this.amazonS3.generatePresignedUrl(new GeneratePresignedUrlRequest(bucketName, objectName).withMethod(method).withExpiration(expiration));
        return url.toString();
    }

    public String getObjectURL(String bucketName, String objectName) {
        URL url = this.amazonS3.getUrl(bucketName, objectName);
        return url.toString();
    }

    public S3Object getObject(String bucketName, String objectName) {
        return this.amazonS3.getObject(bucketName, objectName);
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws IOException {
        this.putObject(bucketName, objectName, stream, stream.available(), "application/octet-stream");
    }

    public PutObjectResult putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(size);
        objectMetadata.setContentType(contextType);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, stream, objectMetadata);
        putObjectRequest.getRequestClientOptions().setReadLimit(Long.valueOf(size).intValue() + 1);
        return this.amazonS3.putObject(putObjectRequest);
    }

    public S3Object getObjectInfo(String bucketName, String objectName) {
        return this.amazonS3.getObject(bucketName, objectName);
    }

    public void removeObject(String bucketName, String objectName) {
        this.amazonS3.deleteObject(bucketName, objectName);
    }

    public void afterPropertiesSet() throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.ossProperties.getEndpoint(), this.ossProperties.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfiguration)).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(this.ossProperties.getPathStyleAccess())).build();
    }

    public OssTemplate(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

