/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.oss;

import com.pig4cloud.plugin.oss.OssProperties;
import com.pig4cloud.plugin.oss.http.OssEndpoint;
import com.pig4cloud.plugin.oss.service.OssTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OssProperties.class})
public class OssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OssTemplate.class})
    @ConditionalOnProperty(prefix="oss", name={"enable"}, havingValue="true", matchIfMissing=true)
    public OssTemplate ossTemplate(OssProperties properties) {
        return new OssTemplate(properties);
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnProperty(prefix="oss", name={"http.enable"}, havingValue="true")
    public OssEndpoint ossEndpoint(OssTemplate template) {
        return new OssEndpoint(template);
    }
}

