/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.kafka.KafkaProducerClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.logback.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;

public class KafkaAppender
extends AppenderBase<ILoggingEvent> {
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private KafkaProducerClient kafkaClient;
    private String appName;
    private String env = "default";
    private String kafkaHosts;
    private String runModel;
    private String expand;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;
    private boolean compressor = false;

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getKafkaHosts() {
        return this.kafkaHosts;
    }

    public void setKafkaHosts(String kafkaHosts) {
        this.kafkaHosts = kafkaHosts;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    protected void append(ILoggingEvent event) {
        if (event != null) {
            this.send(event);
        }
    }

    protected void send(ILoggingEvent event) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, event);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, event);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void start() {
        int a;
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.kafkaClient == null) {
            this.kafkaClient = KafkaProducerClient.getInstance((String)this.kafkaHosts, (String)(this.compressor ? "lz4" : "none"));
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
        }
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
        }
    }
}

