/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class DigitalWatermarkJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        DigitalWatermarkJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("DemoBucket-1234567890");
        request.setTag("DigitalWatermark");
        request.getInput().setObject("1.mp4");
        MediaJobOperation operation = request.getOperation();
        MediaDigitalWatermark digitalWatermark = operation.getDigitalWatermark();
        digitalWatermark.setMessage("demo");
        digitalWatermark.setType("Text");
        digitalWatermark.setVersion("V1");
        operation.getOutput().setBucket("DemoBucket-1234567890");
        operation.getOutput().setRegion("ap-chongqing");
        operation.getOutput().setObject("DigitalWatermark.mp4");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response);
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("DemoBucket-1234567890");
        request.setJobId("j625e550abb9f11ecae7dcbeb4a2*****");
        MediaJobResponse response = client.describeMediaJob(request);
        System.out.println(response);
    }

    public static void describeMediaJobs(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("DemoBucket-1234567890");
        request.setTag("DigitalWatermark");
        MediaListJobResponse response = client.describeMediaJobs(request);
        List<MediaJobObject> jobsDetail = response.getJobsDetailList();
        for (MediaJobObject mediaJobObject : jobsDetail) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("DemoBucket-1234567890");
        request.setJobId("jfb4039b0bb9e11ecbd2081a7c70******");
        Boolean response = client.cancelMediaJob(request);
        System.out.println(response);
    }
}

