/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.AbstractCosResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.model.HeadBucketResult;
import java.util.Map;

public class HeadBucketResultHandler
extends AbstractCosResponseHandler<HeadBucketResult> {
    @Override
    public CosServiceResponse<HeadBucketResult> handle(CosHttpResponse response) throws Exception {
        CosServiceResponse<HeadBucketResult> cosResponse = new CosServiceResponse<HeadBucketResult>();
        boolean isMergeBucket = false;
        boolean isMazBucket = false;
        for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
            String key = header.getKey();
            String value = header.getValue();
            if (key.equalsIgnoreCase("x-cos-bucket-arch") && value.equalsIgnoreCase("OFS")) {
                isMergeBucket = true;
                continue;
            }
            if (!key.equalsIgnoreCase("x-cos-bucket-az-type") || !value.equalsIgnoreCase("MAZ")) continue;
            isMazBucket = true;
        }
        HeadBucketResult result = new HeadBucketResult();
        result.setBucketRegion(response.getHeaders().get("x-cos-bucket-region"));
        result.setMergeBucket(isMergeBucket);
        result.setMazBucket(isMazBucket);
        cosResponse.setResult(result);
        return cosResponse;
    }
}

