/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.AigcMetadata;
import com.qcloud.cos.model.ciModel.job.BatchJobOperation;
import com.qcloud.cos.model.ciModel.job.BatchJobRequest;
import com.qcloud.cos.model.ciModel.job.BatchJobResponse;
import com.qcloud.cos.model.ciModel.job.CallBackKafkaConfig;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import org.apache.commons.codec.binary.Base64;

public class BatchJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        BatchJobDemo.describeMediaJob(client);
    }

    public static void createInventoryTriggerJob(COSClient client) {
        BatchJobRequest request = new BatchJobRequest();
        request.setBucketName("demo-1234567890");
        request.setName("demo");
        request.setType("Job");
        request.getInput().setPrefix("media/");
        BatchJobOperation operation = request.getOperation();
        operation.setTag("Transcode");
        operation.getJobParam().setTemplateId("t0e2b9f4cd25184c6ab73d0c85a6ee9cb5");
        MediaOutputObject output = operation.getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("demo-1234567890");
        output.setObject("out/${InventoryTriggerJobId}.mp4");
        BatchJobResponse response = client.createInventoryTriggerJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createInventoryTriggerJob2(COSClient client) {
        BatchJobRequest request = new BatchJobRequest();
        request.setBucketName("demo-1234567890");
        request.setName("demo");
        request.setType("Job");
        request.getInput().setPrefix("mark1/1");
        BatchJobOperation operation = request.getOperation();
        operation.setTag("PicProcess");
        MediaPicProcessTemplateObject picProcess = operation.getJobParam().getPicProcess();
        picProcess.setIsPicInfo("true");
        picProcess.setProcessRule("imageMogr2/thumbnail/!50p");
        MediaOutputObject output = operation.getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("demo-1234567890");
        output.setObject("out/${InventoryTriggerJobId}");
        BatchJobResponse response = client.createInventoryTriggerJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createInventoryTriggerJobSegmentWithAigcMetadata(COSClient client) {
        BatchJobRequest request = new BatchJobRequest();
        request.setBucketName("demo-1234567890");
        request.setName("demo");
        request.setType("Job");
        request.getInput().setPrefix("media/");
        BatchJobOperation operation = request.getOperation();
        operation.setTag("Segment");
        MediaSegmentObject segment = operation.getJobParam().getSegment();
        segment.setFormat("mp4");
        AigcMetadata aigcMetadata = segment.getAigcMetadata();
        aigcMetadata.setLabel("label");
        aigcMetadata.setContentProducer("testProducer");
        aigcMetadata.setProduceId("testProduceId");
        aigcMetadata.setReservedCode1(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setReservedCode2(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setPropagateId("testPropagateId");
        aigcMetadata.setContentPropagator("testPropagator");
        MediaOutputObject output = operation.getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("demo-1234567890");
        output.setObject("out/${InventoryTriggerJobId}.mp4");
        BatchJobResponse response = client.createInventoryTriggerJob(request);
        System.out.println(response.getJobDetail().getJobId());
        System.out.println(response.getJobDetail().getOperation().getJobParam().getSegment().getAigcMetadata());
    }

    public static void createInventoryTriggerJobWithKafkaCallback(COSClient client) {
        BatchJobRequest request = new BatchJobRequest();
        request.setBucketName("demo-1234567890");
        request.setName("demo");
        request.setType("Job");
        request.getInput().setPrefix("mark1/1");
        BatchJobOperation operation = request.getOperation();
        operation.setTag("PicProcess");
        operation.setCallBackFormat("json");
        operation.setCallBackType("Kafka");
        CallBackKafkaConfig callBackKafkaConfig = operation.getCallBackKafkaConfig();
        callBackKafkaConfig.setRegion("ap-chongqing");
        callBackKafkaConfig.setInstanceId("instance_id");
        callBackKafkaConfig.setTopic("topic");
        MediaPicProcessTemplateObject picProcess = operation.getJobParam().getPicProcess();
        picProcess.setIsPicInfo("true");
        picProcess.setProcessRule("imageMogr2/thumbnail/!50p");
        MediaOutputObject output = operation.getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("demo-1234567890");
        output.setObject("out/${InventoryTriggerJobId}");
        BatchJobResponse response = client.createInventoryTriggerJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        BatchJobRequest request = new BatchJobRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("ba88df4de7b9e11eda55652540038936c");
        BatchJobResponse response = client.describeInventoryTriggerJob(request);
    }
}

