/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileHashCodeConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessJobDetail;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobType;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.FileUnCompressConfig;
import com.qcloud.cos.model.ciModel.job.KeyConfig;
import com.qcloud.cos.model.ciModel.job.ZipPreviewRequest;
import com.qcloud.cos.model.ciModel.job.ZipPreviewResponse;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class FileProcessJobDemo {
    public static void main(String[] args) {
        COSClient client = ClientUtils.getTestClient();
        FileProcessJobDemo.describeFileProcessJob(client);
    }

    public static void createFileCompressJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileCompress);
        FileCompressConfig fileCompressConfig = request.getOperation().getFileCompressConfig();
        fileCompressConfig.setFormat("zip");
        fileCompressConfig.setFlatten("0");
        fileCompressConfig.setIgnoreError("true");
        List<KeyConfig> keyConfigList = fileCompressConfig.getKeyConfigList();
        KeyConfig keyConfig = new KeyConfig();
        keyConfig.setKey("1.jpg");
        keyConfig.setRename("rename-1.jpg");
        keyConfigList.add(keyConfig);
        keyConfig = new KeyConfig();
        keyConfig.setKey("2.jpg");
        keyConfig.setRename("rename-2.jpg");
        keyConfigList.add(keyConfig);
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-chongqing");
        output.setObject("output/demo.zip");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createFileUncompressJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileUncompress);
        request.getInput().setObject("output/demo.zip");
        FileUnCompressConfig fileUnCompressConfig = request.getOperation().getFileUnCompressConfig();
        fileUnCompressConfig.setPrefix("output/");
        fileUnCompressConfig.setPrefixReplaced("1");
        fileUnCompressConfig.setUnCompressKey("demo");
        fileUnCompressConfig.setListingFile(true);
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-chongqing");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createFileHashCodeJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileHashCode);
        request.getInput().setUrl("https://demo-1234567890.cos.ap-chongqing.myqcloud.com/1.docx");
        FileHashCodeConfig fileHashCodeConfig = request.getOperation().getFileHashCodeConfig();
        fileHashCodeConfig.setType("MD5");
        fileHashCodeConfig.setAddToHeader("true");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void describeFileProcessJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("ff96f4bacba8511ee949b8116795*****");
        FileProcessJobResponse response = client.describeFileProcessJob(request);
        FileProcessJobDetail jobDetail = response.getJobDetail();
        System.out.println(Jackson.toJsonString(jobDetail));
    }

    public static void zipPreview(COSClient client) {
        ZipPreviewRequest request = new ZipPreviewRequest();
        request.setBucketName("demo-1234567890");
        request.setObjectKey("filelist_encrypt.rar");
        ZipPreviewResponse response = client.zipPreview(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

