/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.v2.DNADbConfigsRequest;
import com.qcloud.cos.model.ciModel.job.v2.DNADbConfigsResponse;
import com.qcloud.cos.model.ciModel.job.v2.DNADbFilesRequest;
import com.qcloud.cos.model.ciModel.job.v2.DNADbFilesResponse;
import com.qcloud.cos.model.ciModel.job.v2.DnaConfig;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.utils.Jackson;

public class MediaDNADemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        MediaDNADemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("DNA");
        request.getInput().setObject("media/test.mp4");
        DnaConfig dnaConfig = request.getOperation().getDnaConfig();
        dnaConfig.setRuleType("GetFingerPrint");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("j9cdbb46e845411ee9d800f9b074616ce");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeMediaDnaDbFiles(COSClient client) {
        DNADbFilesRequest request = new DNADbFilesRequest();
        request.setBucketName("demo-1234567890");
        request.setDnaDbId("Dnadeed68f8d15a45e6b867491195904695");
        DNADbFilesResponse response = client.describeMediaDnaDbFiles(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeMediaDnaDbs(COSClient client) {
        DNADbConfigsRequest request = new DNADbConfigsRequest();
        request.setBucketName("demo-1234567890");
        DNADbConfigsResponse response = client.describeMediaDnaDbs(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

