/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.AigcMetadata;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.template.MediaHlsEncryptObject;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class SegmentJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        SegmentJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setTag("Segment");
        request.getInput().setObject("1.mp4");
        MediaSegmentObject segment = request.getOperation().getSegment();
        segment.setDuration("5");
        segment.setFormat("mp4");
        MediaHlsEncryptObject hlsEncrypt = segment.getHlsEncrypt();
        hlsEncrypt.setIsHlsEncrypt("true");
        hlsEncrypt.setUriKey("https://example.com/aes.key");
        request.getOperation().getOutput().setBucket("demobucket-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("demo-trans-${Number}.mp4");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response);
    }

    public static void createMediaJobsWithAigcMetadata(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setTag("Segment");
        request.getInput().setObject("1.mp4");
        MediaSegmentObject segment = request.getOperation().getSegment();
        segment.setFormat("mp4");
        AigcMetadata aigcMetadata = segment.getAigcMetadata();
        aigcMetadata.setLabel("label");
        aigcMetadata.setContentProducer("testProducer");
        aigcMetadata.setProduceId("testProduceId");
        aigcMetadata.setReservedCode1(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setReservedCode2(new String(Base64.encodeBase64((byte[])"test".getBytes())));
        aigcMetadata.setPropagateId("testPropagateId");
        aigcMetadata.setContentPropagator("testPropagator");
        request.getOperation().getOutput().setBucket("demobucket-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("demo-trans-result.mp4");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response.getJobsDetail().getOperation().getSegment().getAigcMetadata());
        System.out.println(response.getJobsDetail().getJobId());
    }
}

