/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.cihandler;

import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowDependency;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowNode;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class MediaWorkflowMapConverter
implements Converter {
    public boolean canConvert(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        for (Map.Entry entry : map.entrySet()) {
            writer.startNode((String)entry.getKey());
            context.convertAnother(entry.getValue());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String mapNodeName = reader.getNodeName();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getNodeName();
            if ("Dependencies".equals(mapNodeName)) {
                String text = reader.getValue();
                MediaWorkflowDependency dep = new MediaWorkflowDependency();
                dep.setValue(text != null ? text.trim() : null);
                map.put(key, dep);
            } else if ("Nodes".equals(mapNodeName)) {
                MediaWorkflowNode node = (MediaWorkflowNode)context.convertAnother(map, MediaWorkflowNode.class);
                map.put(key, node);
            } else {
                Object value = context.convertAnother(map, Object.class);
                map.put(key, value);
            }
            reader.moveUp();
        }
        return map;
    }
}

