/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAE;
import com.qcloud.cos.internal.crypto.COSObjectWrapper;
import com.qcloud.cos.internal.crypto.ContentCryptoMaterial;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;

public class COSCryptoModuleAEStrict
extends COSCryptoModuleAE {
    COSCryptoModuleAEStrict(QCLOUDKMS kms, COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, cos, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        if (cryptoConfig.getCryptoMode() != CryptoMode.StrictAuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final boolean isStrict() {
        return true;
    }

    @Override
    protected void securityCheck(ContentCryptoMaterial cekMaterial, COSObjectWrapper retrieved) {
        if (!ContentCryptoScheme.AES_GCM.equals(cekMaterial.getContentCryptoScheme())) {
            throw new SecurityException("COS object [bucket: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + "] not encrypted using authenticated encryption");
        }
    }
}

