/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiDeleteGroupUsers
extends Api {
    public ApiDeleteGroupUsers(Client client) {
        super(client);
    }

    public ApiDeleteGroupUsers(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }
    }

    public static class Request
    extends Api.Request {
        private String alias;
        private DeletedGroupIamUsersParam data;

        public Request(String urlPrefix, String alias, DeletedGroupIamUsersParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.DELETE);
            this.setAuthType(1);
            this.alias = alias;
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.alias == null) {
                throw new QiniuException(new NullPointerException("alias can't empty"));
            }
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/groups");
            this.addPathSegment(this.alias);
            this.addPathSegment("users");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class DeletedGroupIamUsersParam {
            @SerializedName(value="user_aliases")
            private String[] userAliases;

            public DeletedGroupIamUsersParam setUserAliases(String[] userAliases) {
                this.userAliases = userAliases;
                return this;
            }
        }
    }
}

