/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiModifyPolicy
extends Api {
    public ApiModifyPolicy(Client client) {
        super(client);
    }

    public ApiModifyPolicy(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private ModifiedPolicyResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), ModifiedPolicyResp.class);
        }

        public ModifiedPolicyResp getData() {
            return this.data;
        }

        public static final class ModifiedPolicyResp {
            @SerializedName(value="data")
            private ModifiedPolicyData data;

            public ModifiedPolicyData getData() {
                return this.data;
            }
        }

        public static final class ModifiedPolicyData {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;
            @SerializedName(value="statement")
            private ModifiedStatement[] statement;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getDescription() {
                return this.description;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }

            public ModifiedStatement[] getStatement() {
                return this.statement;
            }
        }

        public static final class ModifiedStatement {
            @SerializedName(value="action")
            private String[] actions;
            @SerializedName(value="resource")
            private String[] resources;
            @SerializedName(value="effect")
            private String effect;

            public String[] getActions() {
                return this.actions;
            }

            public String[] getResources() {
                return this.resources;
            }

            public String getEffect() {
                return this.effect;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String alias;
        private ModifyPolicyParam data;

        public Request(String urlPrefix, String alias, ModifyPolicyParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.PATCH);
            this.setAuthType(1);
            this.alias = alias;
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.alias == null) {
                throw new QiniuException(new NullPointerException("alias can't empty"));
            }
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/policies");
            this.addPathSegment(this.alias);
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class ModifyPolicyParam {
            @SerializedName(value="alias")
            private String newAlias;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="statement")
            private ModifyStatement[] statement;

            public ModifyPolicyParam setNewAlias(String newAlias) {
                this.newAlias = newAlias;
                return this;
            }

            public ModifyPolicyParam setDescription(String description) {
                this.description = description;
                return this;
            }

            public ModifyPolicyParam setStatement(ModifyStatement[] statement) {
                this.statement = statement;
                return this;
            }
        }

        public static final class ModifyStatement {
            @SerializedName(value="action")
            private String[] actions;
            @SerializedName(value="resource")
            private String[] resources;
            @SerializedName(value="effect")
            private String effect;

            public ModifyStatement setActions(String[] actions) {
                this.actions = actions;
                return this;
            }

            public ModifyStatement setResources(String[] resources) {
                this.resources = resources;
                return this;
            }

            public ModifyStatement setEffect(String effect) {
                this.effect = effect;
                return this;
            }
        }
    }
}

