/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.http.RequestStreamBody;
import com.qiniu.storage.ApiInterceptorAuth;
import com.qiniu.storage.ApiInterceptorDebug;
import com.qiniu.storage.ApiInterceptorDefaultHeader;
import com.qiniu.storage.ApiInterceptorRetryHosts;
import com.qiniu.storage.ApiInterceptorRetrySimple;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Retry;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class Api {
    private final Client client;
    private final List<Interceptor> interceptors;

    protected Api(Client client) {
        this(client, (Config)null);
    }

    protected Api(Client client, Config config) {
        this(client, Api.createInterceptors(config));
    }

    protected Api(Client client, Interceptor ... interceptors) {
        if (client == null) {
            client = new Client();
        }
        this.client = client;
        ArrayList<Interceptor> is = new ArrayList<Interceptor>();
        is.add(new ApiInterceptorDefaultHeader.Builder().build());
        if (interceptors != null) {
            is.addAll(Arrays.asList(interceptors));
        }
        Collections.sort(is, new Comparator<Interceptor>(){

            @Override
            public int compare(Interceptor o1, Interceptor o2) {
                return o1.priority() - o2.priority();
            }
        });
        Collections.reverse(is);
        this.interceptors = is;
    }

    private static Interceptor[] createInterceptors(Config config) {
        if (config == null) {
            config = new Config.Builder().build();
        }
        return new Interceptor[]{new ApiInterceptorAuth.Builder().setAuth(config.auth).build(), new ApiInterceptorDebug.Builder().setRequestLevel(config.requestDebugLevel).setResponseLevel(config.responseDebugLevel).build(), new ApiInterceptorRetryHosts.Builder().setHostProvider(config.hostProvider).setRetryInterval(config.retryInterval).setRetryMax(config.hostRetryMax).setRetryCondition(config.retryCondition).setHostFreezeCondition(config.hostFreezeCondition).setHostFreezeDuration(config.hostFreezeDuration).build(), new ApiInterceptorRetrySimple.Builder().setRetryMax(config.singleHostRetryMax).setRetryInterval(config.retryInterval).setRetryCondition(config.retryCondition).build()};
    }

    protected com.qiniu.http.Response innerRequest(Request request) throws QiniuException {
        if (this.client == null) {
            ApiUtils.throwInvalidRequestParamException("client");
        }
        MethodType method = request.getMethod();
        String url = request.getUrl().toString();
        StringMap header = request.getHeader();
        RequestBody body = method.hasContent() ? request.getRequestBody() : null;
        Request.Builder requestBuilder = new Request.Builder().url(url).method(method.toString(), body);
        return this.client.send(requestBuilder, header);
    }

    protected com.qiniu.http.Response requestByClient(Request request) throws QiniuException {
        if (request == null) {
            ApiUtils.throwInvalidRequestParamException("request");
        }
        if ((request = request.clone()) == null) {
            throw QiniuException.unrecoverable("request clone error, just retry");
        }
        request.prepareToRequest();
        return this.innerRequest(request);
    }

    protected com.qiniu.http.Response requestWithInterceptor(Request request) throws QiniuException {
        if (request == null) {
            ApiUtils.throwInvalidRequestParamException("request");
        }
        if ((request = request.clone()) == null) {
            throw QiniuException.unrecoverable("request clone error, just retry");
        }
        request.prepareToRequest();
        if (this.interceptors == null || this.interceptors.size() == 0) {
            return this.innerRequest(request);
        }
        Handler handler = new Handler(){

            @Override
            public Response handle(Request req) throws QiniuException {
                return new Response(Api.this.innerRequest(req));
            }
        };
        for (Interceptor interceptor : this.interceptors) {
            final Handler h = handler;
            final Interceptor i = interceptor;
            handler = new Handler(){

                @Override
                public Response handle(Request req) throws QiniuException {
                    return i.intercept(req, h);
                }
            };
        }
        Response response = handler.handle(request);
        return response != null ? response.getResponse() : null;
    }

    protected Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static final class Config {
        public static final int DebugLevelNone = 0;
        public static final int DebugLevelNormal = 1;
        public static final int DebugLevelDetail = 2;
        private final Auth auth;
        private final int hostRetryMax;
        private final int singleHostRetryMax;
        private final Retry.Interval retryInterval;
        private final Retry.RetryCondition retryCondition;
        private final Retry.HostFreezeCondition hostFreezeCondition;
        private final HostProvider hostProvider;
        private final int hostFreezeDuration;
        private final int requestDebugLevel;
        private final int responseDebugLevel;

        private Config(Auth auth, int hostRetryMax, int singleHostRetryMax, Retry.Interval retryInterval, Retry.RetryCondition retryCondition, Retry.HostFreezeCondition hostFreezeCondition, HostProvider hostProvider, int hostFreezeDuration, int requestDebugLevel, int responseDebugLevel) {
            this.auth = auth;
            this.hostRetryMax = hostRetryMax;
            this.singleHostRetryMax = singleHostRetryMax;
            this.retryInterval = retryInterval;
            this.retryCondition = retryCondition;
            this.hostFreezeCondition = hostFreezeCondition;
            this.hostProvider = hostProvider;
            this.hostFreezeDuration = hostFreezeDuration;
            this.requestDebugLevel = requestDebugLevel;
            this.responseDebugLevel = responseDebugLevel;
        }

        public static final class Builder {
            private Auth auth;
            private int hostRetryMax = 1;
            private int singleHostRetryMax = 1;
            private Retry.Interval retryInterval = Retry.defaultInterval();
            private Retry.RetryCondition retryCondition = Retry.defaultCondition();
            private Retry.HostFreezeCondition hostFreezeCondition = Retry.defaultHostFreezeCondition();
            private HostProvider hostProvider = null;
            private int hostFreezeDuration = 600000;
            private int requestDebugLevel = 0;
            private int responseDebugLevel;

            public Builder setAuth(Auth auth) {
                this.auth = auth;
                return this;
            }

            public Builder setHostRetryMax(int hostRetryMax) {
                this.hostRetryMax = hostRetryMax;
                return this;
            }

            public Builder setSingleHostRetryMax(int singleHostRetryMax) {
                this.singleHostRetryMax = singleHostRetryMax;
                return this;
            }

            public Builder setRetryInterval(int retryInterval) {
                this.retryInterval = Retry.staticInterval(retryInterval);
                return this;
            }

            public Builder setRetryInterval(Retry.Interval retryInterval) {
                this.retryInterval = retryInterval;
                return this;
            }

            public Builder setRetryCondition(Retry.RetryCondition retryCondition) {
                this.retryCondition = retryCondition;
                return this;
            }

            public Builder setHostFreezeDuration(int hostFreezeDuration) {
                this.hostFreezeDuration = hostFreezeDuration;
                return this;
            }

            public Builder setHostProvider(HostProvider hostProvider) {
                this.hostProvider = hostProvider;
                return this;
            }

            public Builder setHostFreezeCondition(Retry.HostFreezeCondition hostFreezeCondition) {
                this.hostFreezeCondition = hostFreezeCondition;
                return this;
            }

            public Builder setRequestDebugLevel(int requestDebugLevel) {
                this.requestDebugLevel = requestDebugLevel;
                return this;
            }

            public Builder setResponseDebugLevel(int responseDebugLevel) {
                this.responseDebugLevel = responseDebugLevel;
                return this;
            }

            public Config build() {
                return new Config(this.auth, this.hostRetryMax, this.singleHostRetryMax, this.retryInterval, this.retryCondition, this.hostFreezeCondition, this.hostProvider, this.hostFreezeDuration, this.requestDebugLevel, this.responseDebugLevel);
            }
        }
    }

    static abstract class Interceptor {
        static final int PriorityDefault = 100;
        static final int PriorityRetryHosts = 200;
        static final int PriorityRetrySimple = 300;
        static final int PrioritySetHeader = 400;
        static final int PriorityNormal = 500;
        static final int PriorityAuth = 600;
        static final int PriorityDebug = 700;

        Interceptor() {
        }

        int priority() {
            return 500;
        }

        abstract Response intercept(Request var1, Handler var2) throws QiniuException;
    }

    public static class Request
    implements Cloneable {
        protected static final int AuthTypeNone = 0;
        protected static final int AuthTypeQiniu = 1;
        private int authType = 0;
        private String scheme;
        private String host;
        private int port;
        private String path;
        private List<String> pathSegments = new ArrayList<String>();
        private String query;
        private List<Pair<String, String>> queryPairs = new ArrayList<Pair<String, String>>();
        private MethodType method = MethodType.GET;
        private Map<String, String> header = new HashMap<String, String>();
        private Body body;
        private long streamBodySinkSize = 10240L;

        protected Request(String urlPrefix) {
            if (StringUtils.isNullOrEmpty(urlPrefix)) {
                return;
            }
            try {
                if (!urlPrefix.startsWith("http://") && !urlPrefix.startsWith("https://")) {
                    urlPrefix = "http://" + urlPrefix;
                }
                URL url = new URL(urlPrefix);
                this.scheme = url.getProtocol();
                this.host = url.getHost();
                this.port = url.getPort();
                String segment = url.getPath();
                if (segment != null && segment.startsWith("/")) {
                    segment = segment.substring(1);
                }
                this.addPathSegment(segment);
                String query = url.getQuery();
                if (StringUtils.isNullOrEmpty(query)) {
                    return;
                }
                String[] queryKVs = query.split("&");
                if (queryKVs == null || queryKVs.length == 0) {
                    return;
                }
                for (String kv : queryKVs) {
                    String[] keyValue;
                    if (StringUtils.isNullOrEmpty(kv) || (keyValue = kv.split("=", 2)) == null || keyValue.length != 2) continue;
                    this.addQueryPair(keyValue[0], keyValue[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected Request(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
        }

        protected int getAuthType() {
            return this.authType;
        }

        protected void setAuthType(int authType) {
            this.authType = authType;
        }

        public String getUrlPrefix() {
            return this.scheme + "://" + this.host;
        }

        public String getHost() throws QiniuException {
            return this.host;
        }

        void setHost(String host) {
            URL tmpUrl = UrlUtils.parseHost(host);
            if (tmpUrl == null) {
                this.host = null;
                return;
            }
            this.host = tmpUrl.getHost();
            if (tmpUrl.getPort() >= 0) {
                this.port = tmpUrl.getPort();
            }
        }

        protected void addPathSegment(String segment) {
            if (StringUtils.isNullOrEmpty(segment)) {
                return;
            }
            this.pathSegments.add(segment);
            this.path = null;
        }

        protected void addPathSegment(Boolean segment) {
            this.addPathSegment(segment != false ? "true" : "false");
        }

        protected void addPathSegment(Integer segment) {
            this.addPathSegment(segment + "");
        }

        protected void addPathSegment(Long segment) {
            this.addPathSegment(segment + "");
        }

        String getMethodString() {
            if (this.method == null) {
                return "GET";
            }
            return this.method.toString();
        }

        MethodType getMethod() {
            if (this.method == null) {
                return MethodType.GET;
            }
            return this.method;
        }

        protected void setMethod(MethodType method) {
            if (method == null) {
                return;
            }
            this.method = method;
        }

        public String getPath() throws QiniuException {
            if (this.path == null) {
                this.buildPath();
            }
            return this.path;
        }

        protected void buildPath() throws QiniuException {
            this.path = StringUtils.join(this.pathSegments, "/");
            if (!this.path.isEmpty()) {
                this.path = "/" + this.path;
            }
        }

        protected void addQueryPair(String key, String value) {
            if (StringUtils.isNullOrEmpty(key)) {
                return;
            }
            this.queryPairs.add(new Pair<String, String>(key, value));
            this.query = null;
        }

        protected void addQueryPair(String key, Integer value) {
            this.addQueryPair(key, value + "");
        }

        protected void addQueryPair(String key, Long value) {
            this.addQueryPair(key, value + "");
        }

        protected void addQueryPair(String key, Boolean value) {
            this.addQueryPair(key, value + "");
        }

        public String getQuery() throws QiniuException {
            if (StringUtils.isNullOrEmpty(this.query)) {
                this.buildQuery();
            }
            return this.query;
        }

        protected void buildQuery() throws QiniuException {
            StringBuilder builder = new StringBuilder();
            for (Pair<String, String> pair : this.queryPairs) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                try {
                    builder.append(URLEncoder.encode(pair.getKey(), "UTF-8"));
                    if (pair.getValue() == null) continue;
                    builder.append("=");
                    builder.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    throw new QiniuException(e);
                }
            }
            this.query = builder.toString();
        }

        public void addHeaderField(String key, String value) {
            if (StringUtils.isNullOrEmpty(key) || StringUtils.isNullOrEmpty(value)) {
                return;
            }
            this.header.put(key, value);
        }

        private void removeHeaderField(String key) {
            if (StringUtils.isNullOrEmpty(key)) {
                return;
            }
            this.header.remove(key);
        }

        public StringMap getHeader() throws QiniuException {
            StringMap header = new StringMap();
            for (String key : this.header.keySet()) {
                header.put(key, this.header.get(key));
            }
            if (this.body == null || this.body.getContentType() == null || header.keySet().contains("Content-Type")) {
                return header;
            }
            header.put("Content-Type", this.body.getContentType().toString());
            return header;
        }

        protected void buildHeader() throws QiniuException {
        }

        public URL getUrl() throws QiniuException {
            if (StringUtils.isNullOrEmpty(this.scheme)) {
                throw QiniuException.unrecoverable("scheme is empty, check if scheme is set or your url format is correct.");
            }
            if (StringUtils.isNullOrEmpty(this.host)) {
                throw QiniuException.unrecoverable("host is empty, check if host is set or your url format is correct.");
            }
            try {
                String query;
                String file = "";
                String path = this.getPath();
                if (!StringUtils.isNullOrEmpty(path)) {
                    file = file + path;
                }
                if (!StringUtils.isNullOrEmpty(query = this.getQuery())) {
                    file = file + '?' + query;
                }
                return new URL(this.scheme, this.host, this.port, file);
            }
            catch (Exception e) {
                throw new QiniuException(e);
            }
        }

        protected void setBody(byte[] body, int offset, int size, String contentType) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            this.body = new Body.BytesBody(body, offset, size, contentType);
        }

        protected void setBody(InputStream body, String contentType, long limitSize) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            Body.InputStreamBody b = new Body.InputStreamBody(body, contentType, limitSize);
            b.setSinkSize(this.streamBodySinkSize);
            this.body = b;
        }

        protected void setFormBody(StringMap fields) {
            this.body = new Body.FormBody(fields);
        }

        protected void setMultipartBody(String name, String fileName, StringMap fields, byte[] body, String contentType) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            if (body == null) {
                body = new byte[]{};
            }
            this.body = new Body.MultipartBody(name, fileName, fields, body, contentType);
        }

        protected void setMultipartBody(String name, String fileName, StringMap fields, File body, String contentType) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            this.body = new Body.MultipartBody(name, fileName, fields, body, contentType);
        }

        @Deprecated
        public Request setStreamBodySinkSize(long streamBodySinkSize) {
            this.streamBodySinkSize = streamBodySinkSize;
            if (this.body instanceof Body.InputStreamBody) {
                ((Body.InputStreamBody)this.body).setSinkSize(streamBodySinkSize);
            }
            return this;
        }

        public boolean hasBody() {
            return this.body != null;
        }

        RequestBody getRequestBody() {
            if (!this.hasBody()) {
                return Body.BytesBody.empty().get();
            }
            return this.body.get();
        }

        byte[] getBytesBody() {
            if (!this.hasBody()) {
                return null;
            }
            return this.body.getBytes();
        }

        protected void buildBodyInfo() throws QiniuException {
            if (!this.method.hasContent() || this.body != null) {
                return;
            }
            this.body = new Body.BytesBody(new byte[0], 0, 0, "application/x-www-form-urlencoded");
        }

        boolean canRetry() {
            if (!this.hasBody()) {
                return true;
            }
            return this.body.canReset();
        }

        protected void prepareToRequest() throws QiniuException {
            this.buildPath();
            this.buildQuery();
            this.buildHeader();
            this.buildBodyInfo();
        }

        public Request clone() {
            try {
                Request clone = (Request)super.clone();
                clone.pathSegments = new ArrayList<String>(this.pathSegments);
                clone.queryPairs = new ArrayList<Pair<String, String>>(this.queryPairs);
                clone.header = new HashMap<String, String>(this.header);
                return clone;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        protected static class Pair<K, V> {
            private K key;
            private V value;

            protected Pair(K key, V value) {
                this.key = key;
                this.value = value;
            }

            K getKey() {
                return this.key;
            }

            V getValue() {
                return this.value;
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            public int hashCode() {
                return this.key.hashCode() * 13 + (this.value == null ? 0 : this.value.hashCode());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o instanceof Pair) {
                    Pair pair = (Pair)o;
                    if (!Objects.equals(this.key, pair.key)) {
                        return false;
                    }
                    return Objects.equals(this.value, pair.value);
                }
                return false;
            }
        }

        private static abstract class Body {
            protected RequestBody body;

            private Body() {
            }

            protected MediaType getContentType() {
                if (this.body == null) {
                    return null;
                }
                return this.body.contentType();
            }

            protected boolean canReset() {
                return false;
            }

            protected void reset() throws QiniuException {
                throw QiniuException.unrecoverable("not support reset");
            }

            protected RequestBody get() {
                return this.body;
            }

            protected byte[] getBytes() {
                return null;
            }

            private static final class MultipartBody
            extends Body {
                private final String name;
                private final String fileName;
                private final StringMap fields;
                private final File fileBody;
                private final String bodyContentType;
                private byte[] bytes;
                private byte[] bytesBody;

                private MultipartBody(String name, String fileName, StringMap fields, byte[] body, String bodyContentType) {
                    this.bodyContentType = bodyContentType;
                    this.name = name;
                    this.fileName = fileName;
                    this.fields = fields;
                    this.bytesBody = body;
                    this.fileBody = null;
                    try {
                        this.setupBody();
                    }
                    catch (QiniuException e) {
                        e.printStackTrace();
                    }
                }

                private MultipartBody(String name, String fileName, StringMap fields, File body, String bodyContentType) {
                    this.name = name;
                    this.fileName = fileName;
                    this.fields = fields;
                    this.bodyContentType = bodyContentType;
                    this.bytesBody = null;
                    this.fileBody = body;
                    try {
                        this.setupBody();
                    }
                    catch (QiniuException e) {
                        e.printStackTrace();
                    }
                }

                private static okhttp3.MultipartBody createFormRequestBody(MultipartBody formBody) {
                    MediaType contentType = MediaType.parse((String)formBody.bodyContentType);
                    RequestBody body = null;
                    body = formBody.bytesBody != null ? RequestBody.create((MediaType)contentType, (byte[])formBody.bytesBody) : (formBody.fileBody != null ? RequestBody.create((MediaType)contentType, (File)formBody.fileBody) : RequestBody.create((MediaType)contentType, (byte[])new byte[0]));
                    final MultipartBody.Builder b = new MultipartBody.Builder();
                    if (!StringUtils.isNullOrEmpty(formBody.name)) {
                        b.addFormDataPart(formBody.name, formBody.fileName, body);
                    }
                    if (formBody.fields != null) {
                        formBody.fields.forEach(new StringMap.Consumer(){

                            @Override
                            public void accept(String key, Object value) {
                                b.addFormDataPart(key, value.toString());
                            }
                        });
                    }
                    b.setType(MediaType.parse((String)"multipart/form-data"));
                    return b.build();
                }

                private void setupBody() throws QiniuException {
                    okhttp3.MultipartBody formBody = MultipartBody.createFormRequestBody(this);
                    if (this.bytesBody == null && this.fileBody == null) {
                        Buffer buffer = new Buffer();
                        try {
                            formBody.writeTo((BufferedSink)buffer);
                        }
                        catch (IOException e) {
                            throw QiniuException.unrecoverable(e);
                        }
                        this.bytes = buffer.readByteArray();
                    }
                    this.body = formBody;
                }

                @Override
                protected boolean canReset() {
                    return true;
                }

                @Override
                protected void reset() throws QiniuException {
                    this.setupBody();
                }

                @Override
                public byte[] getBytes() {
                    return this.bytes;
                }
            }

            private static final class FormBody
            extends Body {
                private final StringMap fields;
                private byte[] bytes;

                private FormBody(StringMap fields) {
                    this.fields = fields;
                    try {
                        this.setupBody();
                    }
                    catch (QiniuException e) {
                        e.printStackTrace();
                    }
                }

                private static okhttp3.FormBody createFormRequestBody(FormBody formBody) {
                    final FormBody.Builder builder = new FormBody.Builder();
                    if (formBody.fields != null) {
                        formBody.fields.forEach(new StringMap.Consumer(){

                            @Override
                            public void accept(String key, Object value) {
                                builder.add(key, value.toString());
                            }
                        });
                    }
                    return builder.build();
                }

                private void setupBody() throws QiniuException {
                    okhttp3.FormBody formBody = FormBody.createFormRequestBody(this);
                    Buffer buffer = new Buffer();
                    try {
                        formBody.writeTo((BufferedSink)buffer);
                    }
                    catch (IOException e) {
                        throw QiniuException.unrecoverable(e);
                    }
                    this.bytes = buffer.readByteArray();
                    this.body = formBody;
                }

                @Override
                protected boolean canReset() {
                    return true;
                }

                @Override
                protected void reset() throws QiniuException {
                    this.setupBody();
                }

                @Override
                public byte[] getBytes() {
                    return this.bytes;
                }
            }

            private static final class InputStreamBody
            extends Body {
                private InputStreamBody(InputStream stream, String contentType, long limitSize) {
                    MediaType ct = MediaType.parse((String)contentType);
                    RequestStreamBody b = new RequestStreamBody(stream, ct, limitSize);
                    b.setSinkSize(10240L);
                    this.body = b;
                }

                private void setSinkSize(long sinkSize) {
                    if (this.body instanceof RequestStreamBody) {
                        ((RequestStreamBody)this.body).setSinkSize(sinkSize);
                    }
                }
            }

            private static final class BytesBody
            extends Body {
                private final byte[] bytes;
                private final int offset;
                private final int length;
                private final String contentType;

                private BytesBody(byte[] bytes, int offset, int length, String contentType) {
                    this.bytes = bytes;
                    this.offset = offset;
                    this.length = length;
                    this.contentType = contentType;
                    this.body = BytesBody.createByteRequestBody(this);
                }

                private static BytesBody empty() {
                    return new BytesBody(new byte[0], 0, 0, "application/octet-stream");
                }

                private static RequestBody createByteRequestBody(BytesBody bytesBody) {
                    MediaType ct = MediaType.parse((String)bytesBody.contentType);
                    return RequestBody.create((MediaType)ct, (byte[])bytesBody.bytes, (int)bytesBody.offset, (int)bytesBody.length);
                }

                @Override
                protected boolean canReset() {
                    return true;
                }

                @Override
                protected void reset() throws QiniuException {
                    this.body = BytesBody.createByteRequestBody(this);
                }

                @Override
                public byte[] getBytes() {
                    if (this.bytes == null || this.bytes.length == 0) {
                        return new byte[0];
                    }
                    if (this.offset == 0 && this.length == this.bytes.length) {
                        return this.bytes;
                    }
                    return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
                }
            }
        }
    }

    static interface Handler {
        public Response handle(Request var1) throws QiniuException;
    }

    public static class Response {
        private final com.qiniu.http.Response response;
        private StringMap dataMap;
        private Object[] dataArray;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            this.response = response;
            if (response == null) {
                return;
            }
            if (response.isJson()) {
                String bodyString = response.bodyString();
                try {
                    if (bodyString.startsWith("[")) {
                        this.dataArray = Json.decodeArray(bodyString);
                    } else {
                        this.dataMap = Json.decode(bodyString);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (response.getResponse() != null && response.getResponse().body() != null && response.getResponse().body().contentLength() == 0L) {
                response.close();
            }
        }

        public Object[] getDataArray() {
            return this.dataArray;
        }

        public StringMap getDataMap() {
            return this.dataMap;
        }

        public com.qiniu.http.Response getResponse() {
            return this.response;
        }

        public boolean isOK() {
            return this.response.isOK();
        }

        public String getStringValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        public Long getLongValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            return ApiUtils.objectToLong(value);
        }

        public Integer getIntegerValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            return ApiUtils.objectToInteger(value);
        }

        public Object getValueFromDataMap(String ... keyPath) {
            if (this.dataMap == null) {
                return null;
            }
            return ApiUtils.getValueFromMap(this.dataMap.map(), keyPath);
        }
    }
}

