/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Api;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import okhttp3.Headers;
import okhttp3.Response;

final class ApiInterceptorDebug
extends Api.Interceptor {
    static final int LevelPrintNone = 0;
    static final int LevelPrintNormal = 1;
    static final int LevelPrintDetail = 2;
    private final int requestLevel;
    private final int responseLevel;

    private ApiInterceptorDebug(int requestLevel, int responseLevel) {
        this.requestLevel = requestLevel;
        this.responseLevel = responseLevel;
    }

    private static boolean isNonePrintLevel(int level) {
        return level != 1 && level != 2;
    }

    @Override
    int priority() {
        return 700;
    }

    @Override
    Api.Response intercept(Api.Request request, Api.Handler handler) throws QiniuException {
        if (request == null || ApiInterceptorDebug.isNonePrintLevel(this.requestLevel) && ApiInterceptorDebug.isNonePrintLevel(this.responseLevel)) {
            return handler.handle(request);
        }
        String label = request.getUrl().toString();
        this.printRequest(label, request);
        QiniuException exception = null;
        Api.Response response = null;
        try {
            response = handler.handle(request);
        }
        catch (QiniuException e) {
            exception = e;
        }
        this.printResponse(label, response, exception);
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    private void printRequest(String label, Api.Request request) throws QiniuException {
        byte[] body;
        if (ApiInterceptorDebug.isNonePrintLevel(this.requestLevel)) {
            return;
        }
        StringBuilder info = new StringBuilder(label + " Request:\n");
        info.append(request.getMethodString()).append(" ").append(request.getPath()).append("\n");
        StringMap header = request.getHeader();
        for (String key : header.keySet()) {
            Object value = header.get(key);
            info.append(key).append(": ").append(value).append("\n");
        }
        if (this.requestLevel == 2 && (body = request.getBytesBody()) != null) {
            info.append(StringUtils.utf8String(body)).append("\n");
        }
        System.out.println(info);
    }

    private void printResponse(String label, Api.Response response, Exception e) throws QiniuException {
        if (ApiInterceptorDebug.isNonePrintLevel(this.responseLevel)) {
            return;
        }
        if (response != null && response.getResponse() != null) {
            StringBuilder info = new StringBuilder(label + " Response:\n");
            com.qiniu.http.Response resp = response.getResponse();
            if (resp.getResponse() != null) {
                Response r = resp.getResponse();
                info.append(r.protocol()).append(" ").append(r.code()).append(r.message()).append("\n");
                Headers headers = r.headers();
                for (String key : headers.names()) {
                    String value = headers.get(key);
                    info.append(key).append(": ").append((Object)value).append("\n");
                }
                if (this.responseLevel == 2 && resp.body() != null) {
                    info.append(new String(resp.body())).append("\n");
                }
            } else {
                info.append(resp).append("\n");
            }
            System.out.println(info);
        } else if (e != null) {
            System.out.println(label + " Exception:\n" + e + "\n");
        } else {
            String info = label + " Nothing:\n";
            System.out.println(info);
        }
    }

    static final class Builder {
        private int requestLevel;
        private int responseLevel;

        Builder() {
        }

        Builder setRequestLevel(int requestLevel) {
            this.requestLevel = requestLevel;
            return this;
        }

        Builder setResponseLevel(int responseLevel) {
            this.responseLevel = responseLevel;
            return this;
        }

        Api.Interceptor build() {
            return new ApiInterceptorDebug(this.requestLevel, this.responseLevel);
        }
    }
}

