/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.autoconfiguration;

import com.github.tobato.fastdfs.FdfsClientConfig;
import com.qiwenshare.ufop.autoconfiguration.UFOPProperties;
import com.qiwenshare.ufop.factory.UFOPFactory;
import com.qiwenshare.ufop.operation.copy.product.FastDFSCopier;
import com.qiwenshare.ufop.operation.delete.product.FastDFSDeleter;
import com.qiwenshare.ufop.operation.download.product.FastDFSDownloader;
import com.qiwenshare.ufop.operation.preview.product.FastDFSPreviewer;
import com.qiwenshare.ufop.operation.read.product.FastDFSReader;
import com.qiwenshare.ufop.operation.upload.product.AliyunOSSUploader;
import com.qiwenshare.ufop.operation.upload.product.FastDFSUploader;
import com.qiwenshare.ufop.operation.upload.product.MinioUploader;
import com.qiwenshare.ufop.operation.upload.product.QiniuyunKodoUploader;
import com.qiwenshare.ufop.operation.write.product.FastDFSWriter;
import com.qiwenshare.ufop.util.RedisUtil;
import com.qiwenshare.ufop.util.UFOPUtils;
import com.qiwenshare.ufop.util.concurrent.locks.RedisLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.jmx.support.RegistrationPolicy;

@Configuration
@EnableConfigurationProperties(value={UFOPProperties.class})
@Import(value={FdfsClientConfig.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class UFOPAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(UFOPAutoConfiguration.class);
    @Autowired
    private UFOPProperties ufopProperties;

    @Bean
    public UFOPFactory ufopFactory() {
        UFOPUtils.LOCAL_STORAGE_PATH = this.ufopProperties.getLocalStoragePath();
        String bucketName = this.ufopProperties.getBucketName();
        UFOPUtils.ROOT_PATH = StringUtils.isNotEmpty((CharSequence)bucketName) ? this.ufopProperties.getBucketName() : "upload";
        return new UFOPFactory(this.ufopProperties);
    }

    @Bean
    public FastDFSCopier fastDFSCreater() {
        return new FastDFSCopier();
    }

    @Bean
    public FastDFSUploader fastDFSUploader() {
        return new FastDFSUploader();
    }

    @Bean
    public FastDFSDownloader fastDFSDownloader() {
        return new FastDFSDownloader();
    }

    @Bean
    public FastDFSDeleter fastDFSDeleter() {
        return new FastDFSDeleter();
    }

    @Bean
    public FastDFSReader fastDFSReader() {
        return new FastDFSReader();
    }

    @Bean
    public FastDFSWriter fastDFSWriter() {
        return new FastDFSWriter();
    }

    @Bean
    public FastDFSPreviewer fastDFSPreviewer() {
        return new FastDFSPreviewer(this.ufopProperties.getThumbImage());
    }

    @Bean
    public AliyunOSSUploader aliyunOSSUploader() {
        return new AliyunOSSUploader(this.ufopProperties.getAliyun());
    }

    @Bean
    public MinioUploader minioUploader() {
        return new MinioUploader(this.ufopProperties.getMinio());
    }

    @Bean
    public QiniuyunKodoUploader qiniuyunKodoUploader() {
        return new QiniuyunKodoUploader(this.ufopProperties.getQiniuyun());
    }

    @Bean
    public RedisLock redisLock() {
        return new RedisLock();
    }

    @Bean
    public RedisUtil redisUtil() {
        return new RedisUtil();
    }
}

