/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.copy.product;

import com.aliyun.oss.OSS;
import com.qiwenshare.ufop.config.AliyunConfig;
import com.qiwenshare.ufop.operation.copy.Copier;
import com.qiwenshare.ufop.operation.copy.domain.CopyFile;
import com.qiwenshare.ufop.util.AliyunUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class AliyunOSSCopier
extends Copier {
    private AliyunConfig aliyunConfig;

    public AliyunOSSCopier() {
    }

    public AliyunOSSCopier(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copy(InputStream inputStream, CopyFile copyFile) {
        String uuid = UUID.randomUUID().toString();
        String fileUrl = UFOPUtils.getUploadFileUrl(uuid, copyFile.getExtendName());
        OSS ossClient = AliyunUtils.getOSSClient(this.aliyunConfig);
        try {
            ossClient.putObject(this.aliyunConfig.getOss().getBucketName(), fileUrl, inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            ossClient.shutdown();
        }
        return fileUrl;
    }
}

