/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.copy.product;

import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Auth;
import com.qiwenshare.ufop.config.QiniuyunConfig;
import com.qiwenshare.ufop.operation.copy.Copier;
import com.qiwenshare.ufop.operation.copy.domain.CopyFile;
import com.qiwenshare.ufop.util.QiniuyunUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuyunKodoCopier
extends Copier {
    private static final Logger log = LoggerFactory.getLogger(QiniuyunKodoCopier.class);
    private QiniuyunConfig qiniuyunConfig;

    public QiniuyunKodoCopier() {
    }

    public QiniuyunKodoCopier(QiniuyunConfig qiniuyunConfig) {
        this.qiniuyunConfig = qiniuyunConfig;
    }

    @Override
    public String copy(InputStream inputStream, CopyFile copyFile) {
        String uuid = UUID.randomUUID().toString();
        String fileUrl = UFOPUtils.getUploadFileUrl(uuid, copyFile.getExtendName());
        this.qiniuUpload(fileUrl, inputStream);
        return fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void qiniuUpload(String fileUrl, InputStream inputStream) {
        Configuration cfg = QiniuyunUtils.getCfg(this.qiniuyunConfig);
        Auth auth = Auth.create((String)this.qiniuyunConfig.getKodo().getAccessKey(), (String)this.qiniuyunConfig.getKodo().getSecretKey());
        String upToken = auth.uploadToken(this.qiniuyunConfig.getKodo().getBucketName());
        String localTempDir = UFOPUtils.getStaticPath() + "temp";
        try {
            FileRecorder fileRecorder = new FileRecorder(localTempDir);
            UploadManager uploadManager = new UploadManager(cfg, (Recorder)fileRecorder);
            Response response = uploadManager.put(inputStream, fileUrl, upToken, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info(putRet.key);
            log.info(putRet.hash);
        }
        catch (QiniuException ex) {
            Response r = ex.response;
            System.err.println(r.toString());
            try {
                System.err.println(r.bodyString());
            }
            catch (QiniuException qiniuException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

