/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.download.product;

import com.qiwenshare.ufop.config.MinioConfig;
import com.qiwenshare.ufop.operation.download.Downloader;
import com.qiwenshare.ufop.operation.download.domain.DownloadFile;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioDownloader
extends Downloader {
    private static final Logger log = LoggerFactory.getLogger(MinioDownloader.class);
    private MinioConfig minioConfig;

    public MinioDownloader() {
    }

    public MinioDownloader(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    @Override
    public InputStream getInputStream(DownloadFile downloadFile) {
        GetObjectResponse inputStream = null;
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
            inputStream = downloadFile.getRange() != null ? minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(downloadFile.getFileUrl())).offset(Long.valueOf(downloadFile.getRange().getStart()))).length(Long.valueOf(downloadFile.getRange().getLength()))).build()) : minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(downloadFile.getFileUrl())).build());
        }
        catch (MinioException e) {
            System.out.println("Error occurred: " + (Object)((Object)e));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        return inputStream;
    }
}

