/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.read.product;

import com.qiwenshare.ufop.config.MinioConfig;
import com.qiwenshare.ufop.exception.operation.ReadException;
import com.qiwenshare.ufop.operation.read.Reader;
import com.qiwenshare.ufop.operation.read.domain.ReadFile;
import com.qiwenshare.ufop.util.ReadFileUtils;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger(MinioReader.class);
    private MinioConfig minioConfig;

    public MinioReader() {
    }

    public MinioReader(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    @Override
    public String read(ReadFile readFile) {
        String fileUrl = readFile.getFileUrl();
        String fileType = FilenameUtils.getExtension((String)fileUrl);
        try {
            return ReadFileUtils.getContentByInputStream(fileType, this.getInputStream(readFile.getFileUrl()));
        }
        catch (IOException e) {
            throw new ReadException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    protected InputStream getInputStream(String fileUrl) {
        GetObjectResponse inputStream = null;
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
            inputStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(fileUrl)).build());
        }
        catch (MinioException e) {
            System.out.println("Error occurred: " + (Object)((Object)e));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        return inputStream;
    }
}

