/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload.product;

import com.qiwenshare.ufop.constant.StorageTypeEnum;
import com.qiwenshare.ufop.constant.UploadFileStatusEnum;
import com.qiwenshare.ufop.exception.operation.UploadException;
import com.qiwenshare.ufop.operation.upload.Uploader;
import com.qiwenshare.ufop.operation.upload.domain.UploadFile;
import com.qiwenshare.ufop.operation.upload.domain.UploadFileResult;
import com.qiwenshare.ufop.operation.upload.request.QiwenMultipartFile;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LocalStorageUploader
extends Uploader {
    public static Map<String, String> FILE_URL_MAP = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UploadFileResult doUploadFlow(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        UploadFileResult uploadFileResult;
        block16: {
            uploadFileResult = new UploadFileResult();
            try {
                String fileUrl = UFOPUtils.getUploadFileUrl(uploadFile.getIdentifier(), qiwenMultipartFile.getExtendName());
                if (StringUtils.isNotEmpty((CharSequence)FILE_URL_MAP.get(uploadFile.getIdentifier()))) {
                    fileUrl = FILE_URL_MAP.get(uploadFile.getIdentifier());
                } else {
                    FILE_URL_MAP.put(uploadFile.getIdentifier(), fileUrl);
                }
                String tempFileUrl = fileUrl + "_tmp";
                String confFileUrl = fileUrl.replace("." + qiwenMultipartFile.getExtendName(), ".conf");
                File file = new File(UFOPUtils.getStaticPath() + fileUrl);
                File tempFile = new File(UFOPUtils.getStaticPath() + tempFileUrl);
                File confFile = new File(UFOPUtils.getStaticPath() + confFileUrl);
                RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
                try {
                    FileChannel fileChannel = raf.getChannel();
                    long position = (long)(uploadFile.getChunkNumber() - 1) * uploadFile.getChunkSize();
                    byte[] fileData = qiwenMultipartFile.getUploadBytes();
                    fileChannel.position(position);
                    fileChannel.write(ByteBuffer.wrap(fileData));
                    fileChannel.force(true);
                    fileChannel.close();
                }
                finally {
                    IOUtils.closeQuietly((Closeable)raf);
                }
                boolean isComplete = this.checkUploadStatus(uploadFile, confFile);
                uploadFileResult.setFileUrl(fileUrl);
                uploadFileResult.setFileName(qiwenMultipartFile.getFileName());
                uploadFileResult.setExtendName(qiwenMultipartFile.getExtendName());
                uploadFileResult.setFileSize(uploadFile.getTotalSize());
                uploadFileResult.setStorageType(StorageTypeEnum.LOCAL);
                if (uploadFile.getTotalChunks() == 1) {
                    uploadFileResult.setFileSize(qiwenMultipartFile.getSize());
                }
                uploadFileResult.setIdentifier(uploadFile.getIdentifier());
                if (isComplete) {
                    tempFile.renameTo(file);
                    FILE_URL_MAP.remove(uploadFile.getIdentifier());
                    if (UFOPUtils.isImageFile(uploadFileResult.getExtendName())) {
                        FileInputStream is = null;
                        try {
                            is = new FileInputStream(UFOPUtils.getLocalSaveFile(fileUrl));
                            BufferedImage src = ImageIO.read(is);
                            uploadFileResult.setBufferedImage(src);
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(is);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)is);
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    uploadFileResult.setStatus(UploadFileStatusEnum.SUCCESS);
                    break block16;
                }
                uploadFileResult.setStatus(UploadFileStatusEnum.UNCOMPLATE);
            }
            catch (IOException e) {
                throw new UploadException(e);
            }
        }
        return uploadFileResult;
    }

    @Override
    public void cancelUpload(UploadFile uploadFile) {
        File confFile;
        String fileUrl = FILE_URL_MAP.get(uploadFile.getIdentifier());
        String tempFileUrl = fileUrl + "_tmp";
        String confFileUrl = fileUrl.replace("." + FilenameUtils.getExtension((String)fileUrl), ".conf");
        File tempFile = new File(tempFileUrl);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        if ((confFile = new File(confFileUrl)).exists()) {
            confFile.delete();
        }
    }

    @Override
    protected void doUploadFileChunk(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
    }

    @Override
    protected UploadFileResult organizationalResults(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        return null;
    }
}

