/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload.product;

import com.qiwenshare.ufop.config.MinioConfig;
import com.qiwenshare.ufop.constant.StorageTypeEnum;
import com.qiwenshare.ufop.constant.UploadFileStatusEnum;
import com.qiwenshare.ufop.exception.operation.UploadException;
import com.qiwenshare.ufop.operation.upload.Uploader;
import com.qiwenshare.ufop.operation.upload.domain.UploadFile;
import com.qiwenshare.ufop.operation.upload.domain.UploadFileResult;
import com.qiwenshare.ufop.operation.upload.request.QiwenMultipartFile;
import com.qiwenshare.ufop.util.RedisUtil;
import com.qiwenshare.ufop.util.UFOPUtils;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.MinioException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioUploader
extends Uploader {
    private static final Logger log = LoggerFactory.getLogger(MinioUploader.class);
    private MinioConfig minioConfig;
    @Resource
    RedisUtil redisUtil;

    public MinioUploader() {
    }

    public MinioUploader(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    @Override
    public void cancelUpload(UploadFile uploadFile) {
    }

    @Override
    protected void doUploadFileChunk(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
    }

    @Override
    protected UploadFileResult organizationalResults(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UploadFileResult doUploadFlow(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        UploadFileResult uploadFileResult;
        block11: {
            uploadFileResult = new UploadFileResult();
            try {
                qiwenMultipartFile.getFileUrl(uploadFile.getIdentifier());
                String fileUrl = UFOPUtils.getUploadFileUrl(uploadFile.getIdentifier(), qiwenMultipartFile.getExtendName());
                File tempFile = UFOPUtils.getTempFile(fileUrl);
                File processFile = UFOPUtils.getProcessFile(fileUrl);
                byte[] fileData = qiwenMultipartFile.getUploadBytes();
                this.writeByteDataToFile(fileData, tempFile, uploadFile);
                boolean isComplete = this.checkUploadStatus(uploadFile, processFile);
                uploadFileResult.setFileUrl(fileUrl);
                uploadFileResult.setFileName(qiwenMultipartFile.getFileName());
                uploadFileResult.setExtendName(qiwenMultipartFile.getExtendName());
                uploadFileResult.setFileSize(uploadFile.getTotalSize());
                uploadFileResult.setStorageType(StorageTypeEnum.MINIO);
                if (uploadFile.getTotalChunks() == 1) {
                    uploadFileResult.setFileSize(qiwenMultipartFile.getSize());
                }
                uploadFileResult.setIdentifier(uploadFile.getIdentifier());
                if (isComplete) {
                    this.minioUpload(fileUrl, tempFile, uploadFile);
                    uploadFileResult.setFileUrl(fileUrl);
                    tempFile.delete();
                    if (UFOPUtils.isImageFile(uploadFileResult.getExtendName())) {
                        GetObjectResponse inputStream = null;
                        try {
                            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
                            inputStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(uploadFileResult.getFileUrl())).build());
                            BufferedImage src = ImageIO.read((InputStream)inputStream);
                            uploadFileResult.setBufferedImage(src);
                            IOUtils.closeQuietly((InputStream)inputStream);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        finally {
                            IOUtils.closeQuietly(inputStream);
                        }
                    }
                    uploadFileResult.setStatus(UploadFileStatusEnum.SUCCESS);
                    break block11;
                }
                uploadFileResult.setStatus(UploadFileStatusEnum.UNCOMPLATE);
            }
            catch (IOException e) {
                throw new UploadException(e);
            }
        }
        return uploadFileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minioUpload(String fileUrl, File file, UploadFile uploadFile) {
        FileInputStream inputStream = null;
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
            boolean isExist = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minioConfig.getBucketName())).build());
            if (!isExist) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.minioConfig.getBucketName())).build());
            }
            inputStream = new FileInputStream(file);
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(fileUrl)).stream((InputStream)inputStream, uploadFile.getTotalSize(), 0x500000L).build());
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

